/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import scpsolver.graph.DenseSubgraphExtractor;
import scpsolver.graph.DenseSubgraphNodePartitioner;
import scpsolver.graph.GlobalDenseSubgraphExtractor;
import scpsolver.graph.Graph;
import scpsolver.graph.Node;

public abstract class DenseSubgraphPartitioner
extends DenseSubgraphExtractor {
    protected Graph cuttedGraph;
    protected GlobalDenseSubgraphExtractor andersen;
    protected ArrayList<Graph> subgraphs = new ArrayList();
    private int percentile = 0;
    private int[] percentiles = new int[19];
    private double[] cutDensities = new double[19];

    protected DenseSubgraphPartitioner(int n, double d, double d2) {
        super(n, d, d2);
    }

    protected Graph cutGraph(Graph graph, HashMap<String, Double> hashMap) throws IOException {
        System.out.println("Entering cut method");
        HashMap<Integer, Graph> hashMap2 = new HashMap<Integer, Graph>();
        double d = 0.0;
        double[] dArray = new double[19];
        int n = 0;
        for (int i = 5; i < 100; i += 5) {
            System.out.println("Checking Percentile " + i);
            Graph graph2 = this.cutComponents(graph, hashMap, i);
            hashMap2.put(i, graph2);
            ArrayList<Graph> arrayList = DenseSubgraphExtractor.getConnectedComponents(graph2);
            double d2 = DenseSubgraphPartitioner.computeSubGraphMean(arrayList);
            this.percentiles[n] = i;
            dArray[n] = arrayList.size();
            this.cutDensities[n] = d2;
            if (d2 > d) {
                d = d2;
                this.percentile = i;
                this.subgraphs = arrayList;
            }
            ++n;
        }
        if (this.fileurl != "") {
            if (this instanceof DenseSubgraphNodePartitioner) {
                this.writeCutDensities(this.fileurl + "_node-scoring_cuts_plotdata.txt");
            } else {
                this.writeCutDensities(this.fileurl + "_edge-scoring_cuts_plotdata.txt");
            }
        }
        return (Graph)hashMap2.get(this.percentile);
    }

    public static double computeSubGraphMean(ArrayList<Graph> arrayList) {
        double d = 0.0;
        for (Graph graph : arrayList) {
            d += DenseSubgraphPartitioner.computeDensity(graph.getNumberEdges(), graph.getNumberNodes());
        }
        if (Double.isNaN(d /= (double)arrayList.size())) {
            d = 0.0;
        }
        return d;
    }

    protected abstract Graph cutComponents(Graph var1, HashMap<String, Double> var2, int var3);

    protected int computeDensestIndex(ArrayList<Node> arrayList) {
        int n;
        int n2 = 0;
        double[] dArray = new double[arrayList.size()];
        int n3 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            dArray[n3++] = DenseSubgraphPartitioner.computeDensity(n2 += this.andersen.getCharges().get(arrayList.get(n)).intValue(), n + 1);
        }
        n = 0;
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
            n = i;
        }
        return n;
    }

    protected double computeMinimumScore(int n, HashMap<?, Double> hashMap) {
        if (n > 100 || n < 0) {
            throw new RuntimeException("percentile must be between 0 and 100, given: " + n);
        }
        ArrayList<Double> arrayList = new ArrayList<Double>(hashMap.values());
        Object[] objectArray = new Double[arrayList.size()];
        objectArray = arrayList.toArray(new Double[0]);
        Arrays.sort(objectArray);
        return (Double)objectArray[(int)((double)objectArray.length * ((double)n / 100.0))];
    }

    public void writeCutDensities(String string) throws IOException {
        this.toRFile(string, "Percentile Density\n", this.percentiles, this.cutDensities);
    }

    public Graph getCuttedGraph() {
        return this.cuttedGraph;
    }

    public int getPercentile() {
        return this.percentile;
    }
}

