/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import scpsolver.graph.DenseSubgraphExtractorTest;
import scpsolver.graph.DenseSubgraphPartitioner;
import scpsolver.graph.GlobalDenseSubgraphExtractor;
import scpsolver.graph.Graph;
import scpsolver.graph.Node;

public class DenseSubgraphNodePartitioner
extends DenseSubgraphPartitioner {
    public DenseSubgraphNodePartitioner(int n, double d, double d2) {
        super(n, d, d2);
    }

    public DenseSubgraphNodePartitioner(int n, double d, double d2, GlobalDenseSubgraphExtractor globalDenseSubgraphExtractor) {
        super(n, d, d2);
        this.andersen = globalDenseSubgraphExtractor;
    }

    public DenseSubgraphNodePartitioner(int n, double d, double d2, GlobalDenseSubgraphExtractor globalDenseSubgraphExtractor, String string) {
        super(n, d, d2);
        this.andersen = globalDenseSubgraphExtractor;
        this.fileurl = string;
    }

    public ArrayList<Graph> denseSubgraphs(Graph graph) throws IOException {
        System.out.println("\nComputing Dense Subgraphs with Node Partitioner");
        if (this.andersen == null) {
            this.andersen = new GlobalDenseSubgraphExtractor();
            this.andersen.coreOrdering(graph);
        }
        ArrayList<Node> arrayList = this.andersen.getOrdering();
        HashMap<String, Double> hashMap = this.pulseNodes(graph, arrayList, this.computeDensestIndex(arrayList));
        this.cuttedGraph = this.cutGraph(graph, hashMap);
        ArrayList arrayList2 = this.subgraphs;
        if (this.fileurl != "") {
            int[] nArray = new int[arrayList2.size()];
            double[] dArray = new double[arrayList2.size()];
            for (int i = 0; i < arrayList2.size(); ++i) {
                Graph graph2 = (Graph)arrayList2.get(i);
                nArray[i] = i;
                dArray[i] = DenseSubgraphNodePartitioner.computeDensity(graph2.getNumberEdges(), graph2.getNumberNodes());
            }
            if (arrayList2.size() > 1) {
                DenseSubgraphExtractorTest.writeDensities(arrayList2, this.fileurl + "_node-scoring_subgraph_densities.txt");
            }
        }
        return arrayList2;
    }

    private ArrayList<Node> orderingByScore(Graph graph, HashMap<String, Double> hashMap) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>(hashMap.values());
        Object[] objectArray = arrayList2.toArray(new Double[arrayList2.size()]);
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            for (Node node : graph.getNodes().values()) {
                if (hashMap.get(node.getLabel()) != object) continue;
                arrayList.add(node);
            }
        }
        return arrayList;
    }

    @Override
    protected Graph cutComponents(Graph graph, HashMap<String, Double> hashMap, int n) {
        Graph graph2 = graph.clone();
        double d = this.computeMinimumScore(n, hashMap);
        for (Node node : graph.getNodes().values()) {
            if (hashMap.get(node.getLabel()) != null && !(hashMap.get(node.getLabel()) <= d)) continue;
            graph2.removeNode(graph2.getNode(node.getLabel()));
        }
        return graph2;
    }

    private HashMap<String, Double> pulseNodes(Graph graph, ArrayList<Node> arrayList, int n) {
        System.out.println("Entering: pulse ++ " + n + " Nodes will be directly scored");
        if ((double)n < (double)graph.getNumberNodes() * 0.3) {
            n = new Double((double)graph.getNumberNodes() * 0.3).intValue();
        }
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        for (Node node : arrayList) {
            hashMap.put(node.getLabel(), 0.0);
        }
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            if (n2 % 50 == 0) {
                System.out.println("Pulsing status: " + (int)(100.0 * ((double)i / (double)n)) + "%");
                n2 = 1;
            } else {
                ++n2;
            }
            Node node = arrayList.get(i);
            hashMap.put(node.getLabel(), hashMap.get(node.getLabel()) + this.pulse_start_score);
            this.recNodePulser(this.pulse_range, this.pulse_start_score * this.pulse_decrement, graph.getNode(node.getLabel()), null, hashMap);
        }
        return hashMap;
    }

    private void recNodePulser(int n, double d, Node node, Node node2, HashMap<String, Double> hashMap) {
        if (n == 0) {
            return;
        }
        for (Node node3 : node.getActiveAdjacentNodes()) {
            if (node2 != null && node2.equals(node3)) continue;
            hashMap.put(node3.getLabel(), hashMap.get(node3.getLabel()) + d);
            this.recNodePulser(n - 1, d * this.pulse_decrement, node3, node, hashMap);
        }
    }
}

