/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.graph;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import scpsolver.graph.DenseSubgraphEdgePartitioner;
import scpsolver.graph.DenseSubgraphExtractor;
import scpsolver.graph.DenseSubgraphNodePartitioner;
import scpsolver.graph.DenseSubgraphPartitioner;
import scpsolver.graph.GlobalDenseSubgraphExtractor;
import scpsolver.graph.Graph;
import scpsolver.graph.GraphMiner;
import scpsolver.util.SparseMatrix;

public class DenseSubgraphExtractorTest {
    public static void main(String[] stringArray) throws IOException {
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("randomgraph26");
        for (String string : arrayList) {
            FileWriter fileWriter = new FileWriter(new File(string + "_output.txt"));
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            System.out.println("***** NOW " + string + " *****");
            bufferedWriter.write(string + " ");
            Graph graph = GraphMiner.getGraph(SparseMatrix.readMTX(string));
            bufferedWriter.write(graph.getNumberNodes() + " " + graph.getNumberEdges() + " " + DenseSubgraphExtractorTest.computeDensityRounded(graph) + " ");
            GlobalDenseSubgraphExtractor globalDenseSubgraphExtractor = !bl ? new GlobalDenseSubgraphExtractor() : new GlobalDenseSubgraphExtractor(string);
            Graph graph2 = globalDenseSubgraphExtractor.denseLargeSubgraph(graph);
            ArrayList<Graph> arrayList2 = DenseSubgraphExtractor.getConnectedComponents(graph2);
            bufferedWriter.write(graph2.getNumberNodes() + " " + graph2.getNumberEdges() + " " + DenseSubgraphExtractorTest.computeDensityRounded(graph2) + " " + arrayList2.size() + " " + (double)Math.round(DenseSubgraphPartitioner.computeSubGraphMean(arrayList2) * 1000.0) / 1000.0 + " ");
            DenseSubgraphNodePartitioner denseSubgraphNodePartitioner = !bl ? new DenseSubgraphNodePartitioner(1, 5.0, 0.5, globalDenseSubgraphExtractor) : new DenseSubgraphNodePartitioner(1, 5.0, 0.5, globalDenseSubgraphExtractor, string);
            ArrayList<Graph> arrayList3 = denseSubgraphNodePartitioner.denseSubgraphs(graph);
            Graph graph3 = denseSubgraphNodePartitioner.getCuttedGraph();
            bufferedWriter.write(graph3.getNumberNodes() + " " + graph3.getNumberEdges() + " " + DenseSubgraphExtractorTest.computeDensityRounded(graph3) + " " + arrayList3.size() + " (" + denseSubgraphNodePartitioner.getPercentile() + ") " + (double)Math.round(DenseSubgraphPartitioner.computeSubGraphMean(arrayList3) * 1000.0) / 1000.0 + " ");
            DenseSubgraphEdgePartitioner denseSubgraphEdgePartitioner = !bl ? new DenseSubgraphEdgePartitioner(1, 5.0, 0.5, globalDenseSubgraphExtractor) : new DenseSubgraphEdgePartitioner(1, 5.0, 0.5, globalDenseSubgraphExtractor, string);
            ArrayList<Graph> arrayList4 = denseSubgraphEdgePartitioner.denseSubgraphs(graph);
            Graph graph4 = denseSubgraphEdgePartitioner.getCuttedGraph();
            bufferedWriter.write(graph4.getNumberNodes() + " " + graph4.getNumberEdges() + " " + DenseSubgraphExtractorTest.computeDensityRounded(graph4) + " " + arrayList4.size() + " (" + denseSubgraphEdgePartitioner.getPercentile() + ") " + (double)Math.round(DenseSubgraphPartitioner.computeSubGraphMean(arrayList4) * 1000.0) / 1000.0 + " ");
            bufferedWriter.close();
            fileWriter.close();
        }
    }

    protected static double computeDensityRounded(Graph graph) {
        return (double)Math.round((double)graph.getNumberEdges() / (double)graph.getNumberNodes() * 1000.0) / 1000.0;
    }

    public static void writeDensities(ArrayList<Graph> arrayList, String string) throws IOException {
        FileWriter fileWriter = new FileWriter(new File(string));
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        for (Graph graph : arrayList) {
            bufferedWriter.write((double)graph.getNumberEdges() / (double)graph.getNumberNodes() + " ");
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
        fileWriter.close();
    }

    private static Graph createAndersenGraph() {
        Graph graph = new Graph();
        graph.addEdgeSecure("a", "b");
        graph.addEdgeSecure("b", "f");
        graph.addEdgeSecure("c", "d");
        graph.addEdgeSecure("e", "d");
        graph.addEdgeSecure("d", "f");
        graph.addEdgeSecure("f", "g");
        graph.addEdgeSecure("f", "k");
        graph.addEdgeSecure("f", "h");
        graph.addEdgeSecure("g", "h");
        graph.addEdgeSecure("g", "o");
        graph.addEdgeSecure("g", "j");
        graph.addEdgeSecure("k", "i");
        graph.addEdgeSecure("k", "j");
        graph.addEdgeSecure("h", "o");
        graph.addEdgeSecure("h", "j");
        graph.addEdgeSecure("h", "i");
        graph.addEdgeSecure("h", "m");
        graph.addEdgeSecure("i", "j");
        graph.addEdgeSecure("i", "l");
        graph.addEdgeSecure("l", "m");
        graph.addEdgeSecure("m", "n");
        graph.addEdgeSecure("n", "o");
        graph.addEdgeSecure("n", "p");
        return graph;
    }

    private static Graph createTestGraphNormal() {
        Graph graph = new Graph();
        graph.addEdgeSecure("a", "b");
        graph.addEdgeSecure("b", "c");
        graph.addEdgeSecure("c", "d");
        graph.addEdgeSecure("d", "a");
        graph.addEdgeSecure("c", "a");
        graph.addEdgeSecure("b", "d");
        graph.addEdgeSecure("f", "a");
        graph.addEdgeSecure("f", "d");
        graph.addEdgeSecure("f", "b");
        graph.addEdgeSecure("e", "a");
        graph.addEdgeSecure("e", "f");
        graph.addEdgeSecure("e", "d");
        graph.addEdgeSecure("e", "c");
        graph.addEdgeSecure("e", "b");
        graph.addEdgeSecure("g", "e");
        graph.addEdgeSecure("g", "a");
        graph.addEdgeSecure("g", "b");
        graph.addEdgeSecure("b", "connection1");
        graph.addEdgeSecure("4", "connection1");
        graph.addEdgeSecure("1", "2");
        graph.addEdgeSecure("2", "3");
        graph.addEdgeSecure("3", "4");
        graph.addEdgeSecure("4", "1");
        graph.addEdgeSecure("3", "1");
        graph.addEdgeSecure("2", "4");
        graph.addEdgeSecure("7", "1");
        graph.addEdgeSecure("7", "4");
        graph.addEdgeSecure("7", "2");
        graph.addEdgeSecure("5", "1");
        graph.addEdgeSecure("5", "7");
        graph.addEdgeSecure("5", "4");
        graph.addEdgeSecure("5", "3");
        graph.addEdgeSecure("5", "2");
        graph.addEdgeSecure("6", "5");
        graph.addEdgeSecure("6", "1");
        graph.addEdgeSecure("6", "2");
        return graph;
    }

    private static Graph createComplexTestGraph() {
        Graph graph = new Graph();
        DenseSubgraphExtractorTest.createNodeBall(graph, "a", "b", "c", "d", "e", "f", "g", "h", "i");
        DenseSubgraphExtractorTest.createNodeBall(graph, "1A", "2B", "3C", "4D", "5E", "6F", "7G", "8H", "9I");
        DenseSubgraphExtractorTest.createNodeBall(graph, "Z", "Y", "X", "W", "V", "U", "T", "S", "R");
        DenseSubgraphExtractorTest.createNodeBall(graph, "91A", "92B", "93C", "94D", "95E", "96F", "97G", "98H", "99I");
        DenseSubgraphExtractorTest.createNodeBall(graph, "101", "202", "303", "404", "505", "606", "707", "808", "909");
        DenseSubgraphExtractorTest.createNodeBall(graph, "ZZ", "YY", "XX", "WW", "VV", "UU", "TT", "SS", "RR");
        DenseSubgraphExtractorTest.createNodeBall(graph, "ZZ11", "YY22", "XX33", "WW44", "VV55", "UU66", "TT77", "SS88", "RR99");
        graph.addEdgeSecure("a", "connection1");
        graph.addEdgeSecure("connection1", "connection8");
        graph.addEdgeSecure("3C", "connection2");
        graph.addEdgeSecure("W", "connection2");
        graph.addEdgeSecure("WW", "connection9");
        graph.addEdgeSecure("connection5", "connection9");
        graph.addEdgeSecure("Z", "connection3");
        graph.addEdgeSecure("connection10", "connection3");
        graph.addEdgeSecure("connection4", "connection3");
        graph.addEdgeSecure("98H", "connection4");
        graph.addEdgeSecure("connection10", "connection5");
        graph.addEdgeSecure("404", "connection5");
        graph.addEdgeSecure("a", "connection6");
        graph.addEdgeSecure("YY", "connection6");
        graph.addEdgeSecure("VV55", "connection7");
        graph.addEdgeSecure("connection8", "connection7");
        graph.addEdgeSecure("connection8", "connection10");
        graph.addEdgeSecure("94D", "connection7");
        graph.addEdgeSecure("connection4", "connection11");
        graph.addEdgeSecure("connection11", "connection12");
        graph.addEdgeSecure("connection12", "connection3");
        graph.addEdgeSecure("connection11", "6F");
        return graph;
    }

    private static void createNodeBall(Graph graph, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        graph.addEdgeSecure(string, string2);
        graph.addEdgeSecure(string2, string4);
        graph.addEdgeSecure(string4, string3);
        graph.addEdgeSecure(string3, string);
        graph.addEdgeSecure(string4, string);
        graph.addEdgeSecure(string2, string3);
        graph.addEdgeSecure(string5, string);
        graph.addEdgeSecure(string5, string3);
        graph.addEdgeSecure(string5, string2);
        graph.addEdgeSecure(string6, string);
        graph.addEdgeSecure(string6, string5);
        graph.addEdgeSecure(string6, string3);
        graph.addEdgeSecure(string6, string4);
        graph.addEdgeSecure(string6, string2);
        graph.addEdgeSecure(string7, string6);
        graph.addEdgeSecure(string7, string);
        graph.addEdgeSecure(string7, string2);
        graph.addEdgeSecure(string7, string3);
        graph.addEdgeSecure(string8, string7);
        graph.addEdgeSecure(string8, string4);
        graph.addEdgeSecure(string8, string3);
        graph.addEdgeSecure(string8, string5);
        graph.addEdgeSecure(string8, string6);
        graph.addEdgeSecure(string9, string);
        graph.addEdgeSecure(string9, string7);
        graph.addEdgeSecure(string9, string5);
        graph.addEdgeSecure(string9, string8);
    }
}

