/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.graph;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import scpsolver.graph.Edge;
import scpsolver.graph.Graph;
import scpsolver.graph.Node;

public class DenseSubgraphExtractor {
    protected String fileurl = "";
    protected int pulse_range = 1;
    protected double pulse_start_score = 5.0;
    protected double pulse_decrement = 0.5;

    protected DenseSubgraphExtractor() {
    }

    protected DenseSubgraphExtractor(int n, double d, double d2) {
        this.pulse_range = n;
        this.pulse_start_score = d;
        this.pulse_decrement = d2;
    }

    public static ArrayList<Graph> getConnectedComponents(Graph graph) {
        ArrayList<HashSet<Node>> arrayList = graph.getAllComponentsDL();
        ArrayList<Graph> arrayList2 = new ArrayList<Graph>();
        for (HashSet<Node> hashSet : arrayList) {
            Graph graph2 = new Graph();
            for (Node node : hashSet) {
                for (Node node2 : node.getAdjacentNodes()) {
                    if (!hashSet.contains(node2) || graph2.hasEdge(node.getLabel(), node2.getLabel()) || graph2.hasEdge(node2.getLabel(), node.getLabel())) continue;
                    graph2.addEdgeSecure(node.getLabel(), node2.getLabel());
                }
            }
            graph2.removeCards();
            if (graph2.isEmpty()) continue;
            arrayList2.add(graph2);
        }
        return arrayList2;
    }

    protected static double computeDensity(int n, int n2) {
        return (double)n / (double)n2;
    }

    protected void toRFile(String string, String string2, int[] nArray, double[] dArray) throws IOException {
        File file = new File(string);
        FileWriter fileWriter = new FileWriter(file);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write(string2);
        for (int i = 0; i < nArray.length; ++i) {
            bufferedWriter.write(nArray[i] + " " + dArray[i] + "\n");
        }
        bufferedWriter.close();
        fileWriter.close();
    }

    protected void toRFile(String string, String string2, int[] nArray, double[] dArray, double[] dArray2) throws IOException {
        File file = new File(string);
        FileWriter fileWriter = new FileWriter(file);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write(string2);
        for (int i = 0; i < nArray.length; ++i) {
            bufferedWriter.write(nArray[i] + " " + dArray[i] + " " + dArray2[i] + "\n");
        }
        bufferedWriter.close();
        fileWriter.close();
    }

    protected void writeGraphInformationFile(String string, Graph graph) throws IOException {
        File file = new File(string);
        FileWriter fileWriter = new FileWriter(file);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write("Graph Information: \nNumber of Nodes: " + graph.getNumberNodes() + " \n" + "Density: " + DenseSubgraphExtractor.computeDensity(graph.getNumberEdges(), graph.getNumberNodes()) + " \n" + "Range: " + this.pulse_range + " \n" + "Start Score: " + this.pulse_start_score + " \n" + "Decrement Rate: " + this.pulse_decrement);
        bufferedWriter.close();
        fileWriter.close();
    }

    protected void writeOrdering(ArrayList<?> arrayList, HashMap<?, Double> hashMap, String string) throws IOException {
        File file = new File(string);
        FileWriter fileWriter = new FileWriter(file);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        if (arrayList.get(0) instanceof Node) {
            bufferedWriter.write("Ordering: \nNode Score\n");
            for (Node node : arrayList) {
                bufferedWriter.write(node.getLabel() + " " + hashMap.get(node.getLabel()) + "\n");
            }
        } else {
            bufferedWriter.write("Ordering: \nEdge Score\n");
            for (Edge edge : arrayList) {
                bufferedWriter.write(edge.toNormalizedString() + " " + hashMap.get(edge.toNormalizedString()) + "\n");
            }
        }
        bufferedWriter.close();
        fileWriter.close();
    }
}

