/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import scpsolver.graph.DenseSubgraphExtractorTest;
import scpsolver.graph.DenseSubgraphPartitioner;
import scpsolver.graph.Edge;
import scpsolver.graph.GlobalDenseSubgraphExtractor;
import scpsolver.graph.Graph;
import scpsolver.graph.Node;

public class DenseSubgraphEdgePartitioner
extends DenseSubgraphPartitioner {
    public DenseSubgraphEdgePartitioner(int n, double d, double d2) {
        super(n, d, d2);
    }

    public DenseSubgraphEdgePartitioner(int n, double d, double d2, GlobalDenseSubgraphExtractor globalDenseSubgraphExtractor) {
        super(n, d, d2);
        this.andersen = globalDenseSubgraphExtractor;
    }

    public DenseSubgraphEdgePartitioner(int n, double d, double d2, GlobalDenseSubgraphExtractor globalDenseSubgraphExtractor, String string) {
        super(n, d, d2);
        this.andersen = globalDenseSubgraphExtractor;
        this.fileurl = string;
    }

    public ArrayList<Graph> denseSubgraphs(Graph graph) throws IOException {
        if (this.andersen == null) {
            this.andersen = new GlobalDenseSubgraphExtractor();
            this.andersen.coreOrdering(graph);
        }
        ArrayList<Node> arrayList = this.andersen.getOrdering();
        HashMap<String, Double> hashMap = this.pulseEdges(graph, arrayList, this.computeDensestIndex(arrayList));
        this.cuttedGraph = this.cutGraph(graph, hashMap);
        this.cuttedGraph.removeCards();
        ArrayList arrayList2 = this.subgraphs;
        if (this.fileurl != "") {
            int[] nArray = new int[arrayList2.size()];
            double[] dArray = new double[arrayList2.size()];
            for (int i = 0; i < arrayList2.size(); ++i) {
                Graph graph2 = (Graph)arrayList2.get(i);
                nArray[i] = i;
                dArray[i] = DenseSubgraphEdgePartitioner.computeDensity(graph2.getNumberEdges(), graph2.getNumberNodes());
            }
            if (arrayList2.size() > 1) {
                DenseSubgraphExtractorTest.writeDensities(arrayList2, this.fileurl + "_edge-scoring_subgraph_densities.txt");
            }
        }
        return arrayList2;
    }

    private ArrayList<Edge> edgeOrderingByScore(Graph graph, HashMap<String, Double> hashMap) {
        ArrayList<String> arrayList = new ArrayList<String>(hashMap.keySet());
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        QuickSort.quicksort(stringArray, hashMap);
        ArrayList<Edge> arrayList2 = new ArrayList<Edge>();
        for (String string : stringArray) {
            String string2 = string.substring(1, string.indexOf(" --> "));
            String string3 = string.substring(string.indexOf(" --> ") + 5, string.length() - 1);
            Edge edge = graph.getEdge(string2, string3);
            arrayList2.add(edge);
        }
        return arrayList2;
    }

    @Override
    protected Graph cutComponents(Graph graph, HashMap<String, Double> hashMap, int n) {
        Graph graph2 = graph.clone();
        double d = this.computeMinimumScore(n, hashMap);
        for (Node node : graph.getNodes().values()) {
            for (Edge edge : node.getEdgeList()) {
                if (hashMap.get(edge.toNormalizedString()) != null && !(hashMap.get(edge.toNormalizedString()) <= d)) continue;
                graph2.removeEdge(edge);
            }
        }
        return graph2;
    }

    private HashMap<String, Double> pulseEdges(Graph graph, ArrayList<Node> arrayList, int n) {
        if ((double)n < (double)graph.getNumberNodes() * 0.3) {
            n = new Double((double)graph.getNumberNodes() * 0.3).intValue();
        }
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        for (Node node : graph.getNodes().values()) {
            for (Edge object : node.getEdgeList()) {
                hashMap.put(object.toNormalizedString(), 0.0);
            }
        }
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            if (n2 % 50 == 0) {
                System.out.println("Pulsing status: " + (int)(100.0 * ((double)i / (double)n)) + "%");
                n2 = 1;
            } else {
                ++n2;
            }
            Node node = graph.getNode(arrayList.get(i).getLabel());
            for (Edge edge : node.getEdgeList()) {
                String string = edge.toNormalizedString();
                hashMap.put(string, (double)Math.round((hashMap.get(string) + this.pulse_start_score / this.penalty(node)) * 1000.0) / 1000.0);
            }
            this.recEdgePulser(this.pulse_range - 1, this.pulse_start_score * this.pulse_decrement, graph.getNode(node.getLabel()), null, hashMap);
        }
        return hashMap;
    }

    private void recEdgePulser(int n, double d, Node node, Node node2, HashMap<String, Double> hashMap) {
        if (n == 0) {
            return;
        }
        for (Node node3 : node.getAdjacentNodes()) {
            if (node2 != null && node2.equals(node3)) continue;
            for (Edge edge : node3.getEdgeList()) {
                if (edge.getNode1() == node || edge.getNode2() == node) continue;
                hashMap.put(edge.toNormalizedString(), (double)Math.round((hashMap.get(edge.toNormalizedString()) + d / this.penalty(node3)) * 1000.0) / 1000.0);
            }
            this.recEdgePulser(n - 1, d * this.pulse_decrement, node3, node, hashMap);
        }
    }

    private double penalty(Node node) {
        int n = node.getCardinality();
        double d = n;
        return d;
    }

    public static void main(String[] stringArray) {
        Graph graph = new Graph();
        DenseSubgraphEdgePartitioner denseSubgraphEdgePartitioner = new DenseSubgraphEdgePartitioner(1, 5.0, 0.3);
        graph.addEdgeSecure("A", "B");
        graph.addEdgeSecure("B", "C");
        graph.addEdgeSecure("D", "A");
        graph.addEdgeSecure("B", "D");
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        hashMap.put("(A --> B)", 23.2345);
        hashMap.put("(B --> C)", 23.2345);
        hashMap.put("(A --> D)", 4.2345);
        hashMap.put("(B --> D)", 7.2345);
        for (Edge edge : denseSubgraphEdgePartitioner.edgeOrderingByScore(graph, hashMap)) {
            System.out.println(edge.toNormalizedString());
        }
    }

    private static class QuickSort {
        private static long comparisons = 0L;
        private static long exchanges = 0L;

        private QuickSort() {
        }

        public static void quicksort(String[] stringArray, HashMap<String, Double> hashMap) {
            QuickSort.shuffle(stringArray);
            QuickSort.quicksort(stringArray, 0, stringArray.length - 1, hashMap);
        }

        public static void quicksort(String[] stringArray, int n, int n2, HashMap<String, Double> hashMap) {
            if (n2 <= n) {
                return;
            }
            int n3 = QuickSort.partition(stringArray, n, n2, hashMap);
            QuickSort.quicksort(stringArray, n, n3 - 1, hashMap);
            QuickSort.quicksort(stringArray, n3 + 1, n2, hashMap);
        }

        private static int partition(String[] stringArray, int n, int n2, HashMap<String, Double> hashMap) {
            int n3 = n - 1;
            int n4 = n2;
            while (true) {
                if (QuickSort.less(stringArray[++n3], stringArray[n2], hashMap)) {
                    continue;
                }
                while (QuickSort.less(stringArray[n2], stringArray[--n4], hashMap) && n4 != n) {
                }
                if (n3 >= n4) break;
                QuickSort.exch(stringArray, n3, n4);
            }
            QuickSort.exch(stringArray, n3, n2);
            return n3;
        }

        private static boolean less(String string, String string2, HashMap<String, Double> hashMap) {
            ++comparisons;
            if (hashMap.get(string) == null) {
                return true;
            }
            if (hashMap.get(string2) == null) {
                return false;
            }
            return hashMap.get(string) < hashMap.get(string2);
        }

        private static void exch(String[] stringArray, int n, int n2) {
            ++exchanges;
            String string = stringArray[n];
            stringArray[n] = stringArray[n2];
            stringArray[n2] = string;
        }

        private static void shuffle(String[] stringArray) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = i + (int)(Math.random() * (double)(n - i));
                QuickSort.exch(stringArray, i, n2);
            }
        }
    }
}

