/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.graph;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import scpsolver.constraints.LinearBiggerThanEqualsConstraint;
import scpsolver.constraints.LinearEqualsConstraint;
import scpsolver.constraints.LinearSmallerThanEqualsConstraint;
import scpsolver.graph.ActiveCardinalityComparator;
import scpsolver.graph.CardinalityComparator;
import scpsolver.graph.Edge;
import scpsolver.graph.Graph;
import scpsolver.graph.Node;
import scpsolver.lpsolver.LinearProgramSolver;
import scpsolver.lpsolver.SolverFactory;
import scpsolver.problems.LinearProgram;
import scpsolver.problems.MathematicalProgram;
import scpsolver.util.SparseVector;

public class BipartiteGraph
extends Graph {
    private HashMap<String, Node> nodesleft = new HashMap();
    private HashMap<String, Node> nodesright = new HashMap();

    public HashMap<String, Node> getNodesleft() {
        return this.nodesleft;
    }

    public HashMap<String, Node> getNodesright() {
        return this.nodesright;
    }

    @Override
    public Node getNode(String string) {
        if (this.nodesleft.containsKey(string)) {
            return this.nodesleft.get(string);
        }
        return this.nodesright.get(string);
    }

    @Override
    public void reset() {
        for (Node node : this.nodesleft.values()) {
            node.activateAllEdges();
        }
        for (Node node : this.nodesright.values()) {
            node.activateAllEdges();
        }
    }

    public Node addLeftNode(Node node) {
        Node node2 = this.nodesleft.get(node.getLabel());
        if (node2 == null) {
            this.nodesleft.put(node.getLabel(), node);
            node2 = node;
        } else if (node2.getLabel().compareTo(node.getLabel()) != 0) {
            System.out.println("Collision!? " + node2.getLabel() + " " + node2.getLabel().hashCode() + " " + node.getLabel() + " " + node.getLabel().hashCode());
            System.out.println("This is very serious!!! Please check the hash function of the String labels!");
            System.exit(-1);
        }
        return node2;
    }

    public Node addRightNode(Node node) {
        Node node2 = this.nodesright.get(node.getLabel());
        if (node2 == null) {
            this.nodesright.put(node.getLabel(), node);
            node2 = node;
        } else if (node2.getLabel().compareTo(node.getLabel()) != 0) {
            System.out.println("Collision!? " + node2.getLabel() + " " + node2.getLabel().hashCode() + " " + node.getLabel() + " " + node.getLabel().hashCode());
            System.out.println("This is very serious!!! Please check the hash function of the String labels!");
            System.exit(-1);
        }
        return node2;
    }

    private HashSet<Node> getComponent(Node node, HashSet<Node> hashSet) {
        for (Node node2 : node.getActiveAdjacentNodes()) {
            if (!hashSet.add(node2)) continue;
            this.getComponent(node2, hashSet);
        }
        return hashSet;
    }

    @Override
    public HashSet<Node> getComponent(Node node) {
        HashSet<Node> hashSet = new HashSet<Node>();
        hashSet.add(node);
        return this.getComponent(node, hashSet);
    }

    @Override
    public ArrayList<HashSet<Node>> getAllComponents() {
        ArrayList<HashSet<Node>> arrayList = new ArrayList<HashSet<Node>>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>(this.getNodesleft().values());
        arrayList2.addAll(this.getNodesright().values());
        while (!arrayList2.isEmpty()) {
            HashSet<Node> hashSet = this.getComponent(arrayList2.get(0));
            System.out.println("found clique of size " + hashSet.size());
            arrayList.add(hashSet);
            arrayList2.removeAll(hashSet);
        }
        return arrayList;
    }

    public String toTKZLatex(int n, int n2, double d, String string, String string2) {
        ArrayList<Edge> arrayList;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\\begin{tikzpicture} \n    \\tikzstyle{VertexStyle}=[shape        = circle,\n                             fill         = " + string + ",\n" + "                             minimum size = 40pt,\n" + "                             text         = white,\n" + "                             draw]" + "  \\SetUpEdge[lw         = 1.5pt,\n" + "             color      = black,\n" + "             labelcolor = white,\n" + "             labeltext  = red,\n" + "             labelstyle = {sloped,draw,text=black}],\n" + "\t\t\t  style = {->}");
        ArrayList<Node> arrayList2 = new ArrayList<Node>(this.nodesleft.values());
        ArrayList<Node> arrayList3 = new ArrayList<Node>(this.nodesright.values());
        int n3 = 0;
        for (Node node : arrayList2) {
            stringBuffer.append("\\Vertex[x=" + (double)n3++ * d + ", y=0]{" + node.getLabel() + "}\n");
        }
        stringBuffer.append("\\begin{tikzpicture}\n    \\tikzstyle{VertexStyle}=[shape        = circle,\n                             fill         = " + string2 + ",\n" + "                             minimum size = 40pt,\n" + "                             text         = black,\n" + "                             draw]\n");
        n3 = 0;
        for (Node node : arrayList2) {
            stringBuffer.append("\\Vertex[x=" + (double)n3++ * d + ", y=8]{" + node.getLabel() + "}\n");
        }
        for (Node node : arrayList2) {
            arrayList = node.getEdgeList();
            for (Edge edge : arrayList) {
                if (edge.getNode1() != node) continue;
                stringBuffer.append("\\Edges[label=\"" + edge.getLabel() + "\"](" + edge.getNode1().getLabel() + "," + edge.getNode2().getLabel() + ")\n");
            }
        }
        for (Node node : arrayList3) {
            arrayList = node.getEdgeList();
            for (Edge edge : arrayList) {
                if (edge.getNode1() != node) continue;
                stringBuffer.append("\\Edges[label=\"" + edge.getLabel() + "\"](" + edge.getNode1().getLabel() + "," + edge.getNode2().getLabel() + ")\n");
            }
        }
        stringBuffer.append("\\end{tikzpicture}");
        return stringBuffer.toString();
    }

    public void removeLeftNode(Node node) {
        node.removeAllEdges();
        this.nodesleft.remove(node.getLabel());
    }

    public int getNumberOfLeftNodes() {
        return this.nodesleft.size();
    }

    public int getNumberOfRightNodes() {
        return this.nodesright.size();
    }

    @Override
    public boolean hasEdge(String string, String string2) {
        if (!this.nodesleft.containsKey(string)) {
            return false;
        }
        if (!this.nodesright.containsKey(string2)) {
            return false;
        }
        Node node = this.nodesleft.get(string);
        Node node2 = this.nodesright.get(string2);
        return node.getOutboundNodes().contains(node2);
    }

    @Override
    public Edge addEdgeSecure(String string, String string2, boolean bl) {
        Node node = this.addLeftNode(new Node(string));
        Node node2 = this.addRightNode(new Node(string2));
        if (bl) {
            return node2.addEdgeto(node);
        }
        return node.addEdgeto(node2);
    }

    @Override
    public Edge addEdgeSecure(String string, String string2) {
        return this.addEdgeSecure(string, string2, false);
    }

    @Override
    public Edge addEdgeSecure(String string, String string2, String string3, boolean bl) {
        Edge edge = this.addEdgeSecure(string, string2, bl);
        edge.setLabel(string3);
        return edge;
    }

    public LinearProgram getDenseConveringWithSizeLinearProgram(int n) {
        int n2;
        int n3 = this.getNumberOfLeftNodes() + this.getNumberOfRightNodes();
        SparseVector sparseVector = new SparseVector(n3, this.getNumberOfRightNodes());
        for (int i = 0; i < this.getNumberOfRightNodes(); ++i) {
            sparseVector.set(i, 1.0);
        }
        LinearProgram linearProgram = new LinearProgram(sparseVector);
        SparseVector sparseVector2 = new SparseVector(n3, this.getNumberOfLeftNodes());
        for (int i = this.getNumberOfRightNodes(); i < n3; ++i) {
            sparseVector2.set(i, 1.0);
        }
        LinearEqualsConstraint linearEqualsConstraint = new LinearEqualsConstraint(sparseVector2, (double)n, "sum of selected set equals k");
        linearProgram.addConstraint(linearEqualsConstraint);
        Iterator<Node> iterator = this.nodesright.values().iterator();
        System.out.println("Adding constraints..");
        ArrayList<Node> arrayList = new ArrayList<Node>(this.nodesleft.values());
        HashMap<Node, Integer> hashMap = new HashMap<Node, Integer>();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            hashMap.put(arrayList.get(n2), n2);
        }
        n2 = 0;
        while (iterator.hasNext()) {
            Node node = iterator.next();
            ArrayList<Node> arrayList2 = node.getActiveAdjacentNodes();
            String string = "completeness(" + node.label + ")";
            SparseVector sparseVector3 = new SparseVector(n3, arrayList2.size() + 1);
            for (Node node2 : arrayList2) {
                sparseVector3.set(this.getNumberOfRightNodes() + (Integer)hashMap.get(node2), 1.0);
            }
            sparseVector3.set(n2++, -1.0);
            linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(sparseVector3, 0.0, string));
        }
        linearProgram.setMinProblem(false);
        for (int i = 0; i < n3; ++i) {
            linearProgram.setBinary(i);
        }
        return linearProgram;
    }

    public ArrayList<Node> solveSetCoveringProblemGreedy() {
        Node node2;
        for (Node node2 : this.nodesleft.values()) {
            node2.setComparator(new CardinalityComparator());
        }
        for (Node node2 : this.nodesright.values()) {
            node2.setComparator(new CardinalityComparator());
        }
        ArrayList arrayList = new ArrayList();
        while ((node2 = Collections.max(this.nodesleft.values())).getCardinality() != 0) {
            arrayList.add(node2);
            System.out.println("Node: " + node2.getLabel() + " score: " + node2.getCardinality());
            for (Node node3 : node2.getAdjacentNodes()) {
                node3.removeAllEdges();
            }
            node2.removeAllEdges();
        }
        return arrayList;
    }

    public ArrayList<Node> solveSetCoveringProblemGreedyActive(Comparator<Node> comparator) {
        for (Node node : this.nodesleft.values()) {
            node.setComparator(comparator);
        }
        for (Node node : this.nodesright.values()) {
            node.setComparator(comparator);
        }
        ArrayList arrayList = new ArrayList();
        while (!this.isValidCovering(arrayList)) {
            Node node;
            node = Collections.max(this.nodesleft.values());
            arrayList.add(node);
            for (Node node2 : node.getAdjacentNodes()) {
                node2.deactivateAllEdges();
            }
            node.deactivateAllEdges();
        }
        this.reset();
        return arrayList;
    }

    public ArrayList<Node> solveSetCoveringProblemGreedyActive(Comparator<Node> comparator, int n) {
        for (Node node : this.nodesleft.values()) {
            node.setComparator(comparator);
        }
        for (Node node : this.nodesright.values()) {
            node.setComparator(comparator);
        }
        ArrayList arrayList = new ArrayList();
        while (arrayList.size() < n) {
            Node node;
            node = Collections.max(this.nodesleft.values());
            arrayList.add(node);
            for (Node node2 : node.getAdjacentNodes()) {
                node2.deactivateAllEdges();
            }
            node.deactivateAllEdges();
        }
        this.reset();
        return arrayList;
    }

    public LinearProgram getSetCoverLinearProgram(int n) {
        double[] dArray = new double[this.getNumberOfLeftNodes()];
        ArrayList<Node> arrayList = new ArrayList<Node>(this.nodesleft.values());
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 1.0;
        }
        System.out.println("Instanciating LP");
        LinearProgram linearProgram = new LinearProgram(dArray);
        System.out.println("Setting all to binary..");
        for (int i = 0; i < dArray.length; ++i) {
            linearProgram.setBinary(i);
        }
        Iterator<Node> iterator = this.nodesright.values().iterator();
        System.out.println("Adding constraints..");
        HashMap<Node, Integer> hashMap = new HashMap<Node, Integer>();
        for (int i = 0; i < arrayList.size(); ++i) {
            hashMap.put(arrayList.get(i), i);
        }
        while (iterator.hasNext()) {
            Node node = iterator.next();
            ArrayList<Node> arrayList2 = node.getActiveAdjacentNodes();
            String string = "completeness(" + node.label + ")";
            SparseVector sparseVector = new SparseVector(dArray.length, arrayList2.size());
            for (Node node2 : arrayList2) {
                sparseVector.set((Integer)hashMap.get(node2), 1.0);
            }
            linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(sparseVector, (double)n, string));
        }
        linearProgram.setMinProblem(true);
        System.out.println("LP formulation ready!");
        return linearProgram;
    }

    public LinearProgram getDualCoverLinearProgram(int n) {
        Object object;
        int n2;
        double[] dArray = new double[this.getNumberOfLeftNodes() + this.getNumberOfRightNodes()];
        ArrayList<Node> arrayList = new ArrayList<Node>(this.nodesleft.values());
        ArrayList<Node> arrayList2 = new ArrayList<Node>(this.nodesright.values());
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray[n2] = 0.0;
        }
        for (n2 = this.nodesleft.size(); n2 < dArray.length; ++n2) {
            dArray[n2] = 1.0;
        }
        System.out.println("Instanciating LP");
        LinearProgram linearProgram = new LinearProgram(dArray);
        System.out.println("Setting all to binary..");
        for (int i = 0; i < dArray.length; ++i) {
            linearProgram.setBinary(i);
        }
        Iterator<Node> iterator = this.nodesright.values().iterator();
        System.out.println("Adding constraints..");
        HashMap<Node, Integer> hashMap = new HashMap<Node, Integer>();
        int n3 = 0;
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            hashMap.put(arrayList.get(n3), n3);
        }
        while (iterator.hasNext()) {
            object = iterator.next();
            ArrayList<Node> arrayList3 = ((Node)object).getActiveAdjacentNodes();
            String string = "completeness(" + ((Node)object).label + ")";
            SparseVector sparseVector = new SparseVector(dArray.length, arrayList3.size());
            for (Node node : arrayList3) {
                sparseVector.set((Integer)hashMap.get(node), 1.0);
            }
            sparseVector.set(this.getNumberOfLeftNodes() + arrayList2.indexOf(object), -1.0);
            linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(sparseVector, 1.0, string));
        }
        object = new double[dArray.length];
        for (int i = 0; i < this.getNumberOfLeftNodes(); ++i) {
            object[i] = 1.0;
        }
        linearProgram.addConstraint(new LinearSmallerThanEqualsConstraint((double[])object, (double)n, "Maximum cost"));
        linearProgram.setMinProblem(false);
        System.out.println("LP formulation ready!");
        return linearProgram;
    }

    public LinearProgram getSetCoverLinearProgramMulticover() {
        double[] dArray = new double[this.getNumberOfLeftNodes()];
        ArrayList<Node> arrayList = new ArrayList<Node>(this.nodesleft.values());
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 1.0;
        }
        System.out.println("Instanciating LP");
        LinearProgram linearProgram = new LinearProgram(dArray);
        System.out.println("Setting all to binary..");
        for (int i = 0; i < dArray.length; ++i) {
            linearProgram.setBinary(i);
        }
        Iterator<Node> iterator = this.nodesright.values().iterator();
        System.out.println("Adding constraints..");
        HashMap<Node, Integer> hashMap = new HashMap<Node, Integer>();
        for (int i = 0; i < arrayList.size(); ++i) {
            hashMap.put(arrayList.get(i), i);
        }
        while (iterator.hasNext()) {
            Node node = iterator.next();
            ArrayList<Node> arrayList2 = node.getActiveAdjacentNodes();
            String string = "completeness(" + node.label + ")";
            SparseVector sparseVector = new SparseVector(dArray.length, arrayList2.size());
            for (Node node2 : arrayList2) {
                sparseVector.set((Integer)hashMap.get(node2), 1.0);
            }
            if (sparseVector.getUsed() > 1) {
                linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(sparseVector, 2.0, string));
                continue;
            }
            for (Node node2 : arrayList2) {
                System.out.println(node2);
            }
            System.out.println(node.getLabel() + " can't be multicovered");
            linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(sparseVector, 1.0, string));
        }
        linearProgram.setMinProblem(true);
        System.out.println("LP formulation ready!");
        return linearProgram;
    }

    public LinearProgram getSetCoverLinearProgramRelaxed(int n) {
        double[] dArray = new double[this.getNumberOfLeftNodes()];
        ArrayList<Node> arrayList = new ArrayList<Node>(this.nodesleft.values());
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 1.0;
        }
        System.out.println("Instanciating LP");
        LinearProgram linearProgram = new LinearProgram(dArray);
        linearProgram.setLowerbound(MathematicalProgram.makeDoubleArray(linearProgram.getDimension(), 0.0));
        linearProgram.setUpperbound(MathematicalProgram.makeDoubleArray(linearProgram.getDimension(), 1.0));
        Iterator<Node> iterator = this.nodesright.values().iterator();
        System.out.println("Adding constraints..");
        HashMap<Node, Integer> hashMap = new HashMap<Node, Integer>();
        for (int i = 0; i < arrayList.size(); ++i) {
            hashMap.put(arrayList.get(i), i);
        }
        while (iterator.hasNext()) {
            Node node = iterator.next();
            ArrayList<Node> arrayList2 = node.getActiveAdjacentNodes();
            String string = "completeness(" + node.label + ")";
            SparseVector sparseVector = new SparseVector(dArray.length, arrayList2.size());
            for (Node node2 : arrayList2) {
                sparseVector.set((Integer)hashMap.get(node2), 1.0);
            }
            linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(sparseVector, 1.0, string));
        }
        linearProgram.setMinProblem(true);
        System.out.println("LP formulation ready!");
        return linearProgram;
    }

    public ArrayList<Node> solveCoveringProblemLPApproximation(LinearProgramSolver linearProgramSolver) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        LinearProgram linearProgram = this.getSetCoverLinearProgramRelaxed(1);
        double[] dArray = linearProgramSolver.solve(linearProgram);
        ArrayList<Node> arrayList2 = new ArrayList<Node>(this.nodesleft.values());
        for (int i = 0; i < dArray.length; ++i) {
            ArrayList<Node> arrayList3 = arrayList2.get(i).getActiveAdjacentNodes();
            int n = 0;
            for (Node node : arrayList3) {
                int n2 = node.getCardinality();
                n = n2 > n ? n2 : n;
            }
            if (dArray[i] >= 1.0 / (double)n) {
                arrayList.add(arrayList2.get(i));
                continue;
            }
            if (!(dArray[i] > 0.0)) continue;
            System.out.println(arrayList2.get(i) + " " + dArray[i] + " " + 1.0 / (double)n);
        }
        return arrayList;
    }

    public ArrayList<Node> solveLinearProgramForSubProblem(ArrayList<Node> arrayList, ArrayList<Node> arrayList2, ArrayList<Node> arrayList3, LinearProgramSolver linearProgramSolver) {
        return arrayList3;
    }

    public ArrayList<Node> solveDenseCoveringProblemLP(LinearProgramSolver linearProgramSolver, int n) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        LinearProgram linearProgram = this.getDenseConveringWithSizeLinearProgram(n);
        double[] dArray = linearProgramSolver.solve(linearProgram);
        ArrayList<Node> arrayList2 = new ArrayList<Node>(this.getNodesleft().values());
        for (int i = this.getNumberOfRightNodes(); i < dArray.length; ++i) {
            if (!(dArray[i] > 0.99)) continue;
            arrayList.add(arrayList2.get(i - this.getNumberOfRightNodes()));
        }
        return arrayList;
    }

    public ArrayList<Node> solveCoveringProblemLP(LinearProgramSolver linearProgramSolver, int n) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        LinearProgram linearProgram = this.getSetCoverLinearProgram(n);
        double[] dArray = linearProgramSolver.solve(linearProgram);
        ArrayList<Node> arrayList2 = new ArrayList<Node>(this.nodesleft.values());
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] >= 0.999)) continue;
            arrayList.add(arrayList2.get(i));
        }
        return arrayList;
    }

    public ArrayList<Node> solveDualCoveringProblemLP(LinearProgramSolver linearProgramSolver, int n) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        LinearProgram linearProgram = this.getDualCoverLinearProgram(n);
        double[] dArray = linearProgramSolver.solve(linearProgram);
        ArrayList<Node> arrayList2 = new ArrayList<Node>(this.nodesleft.values());
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (!(dArray[i] >= 0.999)) continue;
            arrayList.add(arrayList2.get(i));
        }
        return arrayList;
    }

    public ArrayList<Node> solveCoveringProblemLPMulticover(LinearProgramSolver linearProgramSolver) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        LinearProgram linearProgram = this.getSetCoverLinearProgramMulticover();
        double[] dArray = linearProgramSolver.solve(linearProgram);
        ArrayList<Node> arrayList2 = new ArrayList<Node>(this.nodesleft.values());
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] >= 0.999)) continue;
            arrayList.add(arrayList2.get(i));
        }
        return arrayList;
    }

    public String toSetCoverGPML(int n) {
        Iterator<Node> iterator;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# SET COVER PROBLEM\n");
        stringBuffer.append("set E;\n");
        stringBuffer.append("set S;\n");
        stringBuffer.append("param  M{s in S, e in E} binary;\n");
        stringBuffer.append("var x{s in S} binary;\n");
        stringBuffer.append("minimize covering: sum{s in S} x[s];\n");
        stringBuffer.append("subject to completeness{e in E}: sum{s in S} M[s,e] * x[s] >= " + n + ";\n");
        stringBuffer.append("solve;\n");
        stringBuffer.append("printf \"SET: \\n\";");
        stringBuffer.append("for{s in S} {\n");
        stringBuffer.append("    printf '%s ', if  x[s] then 'INSET' else 'OUTSET';\n");
        stringBuffer.append("    printf '%s\\n', s;\n");
        stringBuffer.append(" }\n");
        stringBuffer.append("data;\n");
        stringBuffer.append("set E ");
        Iterator<Node> iterator2 = this.nodesright.values().iterator();
        while (iterator2.hasNext()) {
            iterator = iterator2.next();
            stringBuffer.append("\"" + iterator + "\"");
            if (!iterator2.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(";\n");
        stringBuffer.append("set S ");
        iterator = this.nodesleft.values().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            stringBuffer.append("\"" + node + "\"");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(";\n");
        stringBuffer.append("param M:\n\t");
        iterator2 = this.nodesright.values().iterator();
        while (iterator2.hasNext()) {
            stringBuffer.append("\"" + iterator2.next() + "\"\t");
        }
        stringBuffer.append(":=\n");
        for (Node node : this.nodesleft.values()) {
            ArrayList<Node> arrayList = node.getActiveAdjacentNodes();
            stringBuffer.append("\"" + node + "\"\t");
            for (Node node2 : this.nodesright.values()) {
                boolean bl = arrayList.contains(node2);
                stringBuffer.append((bl ? "1" : "0") + "\t");
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(";\n");
        stringBuffer.append("end;");
        return stringBuffer.toString();
    }

    @Override
    public String toGML() {
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable<Node, Integer> hashtable = new Hashtable<Node, Integer>();
        stringBuffer.append("graph [ \n comment \"no comment\"  \n directed 1  \n id 42  \n label \"Bipartite Graph\"\n");
        int n = 1;
        double d = 1.0;
        int n2 = 0;
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.addAll(this.nodesleft.values());
        Collections.sort(linkedList);
        for (Node node : linkedList) {
            if (node.getCardinality() == 0) {
                System.out.println(node.getLabel() + " has  card");
            }
            if (node.getCardinality() <= n2) continue;
            stringBuffer.append("node [ \n id " + n + "\n label \"" + node.getLabel() + "\"\n");
            stringBuffer.append("graphics\n [\n x       35.0\n y       " + d + " \n fill    \"#FFCC00\"\n]\n");
            stringBuffer.append("]\n");
            hashtable.put(node, n);
            ++n;
            d += 70.0;
        }
        double d2 = 1.0;
        LinkedList<Node> linkedList2 = new LinkedList<Node>();
        linkedList2.addAll(this.nodesright.values());
        Collections.sort(linkedList2);
        for (Node node : linkedList2) {
            if (node.getCardinality() == 0) {
                System.out.println(node.getLabel() + " has 0 card");
            }
            stringBuffer.append("node [\n id " + n + "\n label \"" + node.getLabel() + "\"\n");
            stringBuffer.append("graphics\n [\n x       10000.0\n y       " + d2 + " \n fill    \"#00CC00\"\n]\n");
            stringBuffer.append("]\n");
            hashtable.put(node, n);
            ++n;
            d2 += 70.0;
        }
        for (Node node : this.nodesleft.values()) {
            if (node.getCardinality() <= n2) continue;
            for (Edge edge : node.getEdgeList()) {
                stringBuffer.append("edge [\n source " + hashtable.get(edge.node1) + "\n target " + hashtable.get(edge.node2) + "\n label \"\"\n]\n");
            }
        }
        return stringBuffer.toString();
    }

    public void toSetCoverGPML(String string, int n) {
        try {
            System.out.println("Writing MathProg file " + string);
            FileWriter fileWriter = new FileWriter(new File(string));
            fileWriter.write(this.toSetCoverGPML(n));
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Could not write GPML-file " + string + " because" + exception.getMessage());
        }
    }

    public void toSetCoverGPMLStream(String string, int n) {
        try {
            Iterator<Node> iterator;
            System.out.println("Writing MathProg file " + string);
            FileWriter fileWriter = new FileWriter(new File(string));
            fileWriter.write("# SET COVER PROBLEM\n");
            fileWriter.write("set E;\n");
            fileWriter.write("set S;\n");
            fileWriter.write("param  M{s in S, e in E} binary;\n");
            fileWriter.write("var x{s in S} binary;\n");
            fileWriter.write("minimize covering: sum{s in S} x[s];\n");
            fileWriter.write("subject to completeness{e in E}: sum{s in S} M[s,e] * x[s] >= " + n + ";\n");
            fileWriter.write("solve;\n");
            fileWriter.write("printf \"SET: \\n\";");
            fileWriter.write("for{s in S} {\n");
            fileWriter.write("    printf '%s ', if  x[s] then 'INSET' else 'OUTSET';\n");
            fileWriter.write("    printf '%s\\n', s;\n");
            fileWriter.write(" }\n");
            fileWriter.write("data;\n");
            fileWriter.write("set E ");
            Iterator<Node> iterator2 = this.nodesright.values().iterator();
            while (iterator2.hasNext()) {
                iterator = iterator2.next();
                fileWriter.write("\"" + iterator + "\"");
                if (!iterator2.hasNext()) continue;
                fileWriter.write(", ");
            }
            fileWriter.write(";\n");
            fileWriter.write("set S ");
            iterator = this.nodesleft.values().iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                fileWriter.write("\"" + node + "\"");
                if (!iterator.hasNext()) continue;
                fileWriter.write(", ");
            }
            fileWriter.write(";\n");
            fileWriter.write("param M:\n\t");
            iterator2 = this.nodesright.values().iterator();
            while (iterator2.hasNext()) {
                fileWriter.write("\"" + iterator2.next() + "\"\t");
            }
            fileWriter.write(":=\n");
            for (Node node : this.nodesleft.values()) {
                ArrayList<Node> arrayList = node.getActiveAdjacentNodes();
                fileWriter.write("\"" + node + "\"\t");
                for (Node node2 : this.nodesright.values()) {
                    boolean bl = arrayList.contains(node2);
                    fileWriter.write((bl ? "1" : "0") + "\t");
                }
                fileWriter.write("\n");
            }
            fileWriter.write(";\n");
            fileWriter.write("end;");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Could not write GPML-file " + string + " because" + exception.getMessage());
        }
    }

    public void toSetCoverOPBStream(String string, int n) {
        try {
            System.out.println("Writing OPB file " + string);
            FileWriter fileWriter = new FileWriter(new File(string));
            fileWriter.write("min: ");
            Iterator<Node> iterator = this.nodesleft.values().iterator();
            while (iterator.hasNext()) {
                Node node = iterator.next();
                fileWriter.write(node.label.replace('|', 'X'));
                if (!iterator.hasNext()) continue;
                fileWriter.write(" + ");
            }
            fileWriter.write(" ;\n");
            for (Node node : this.nodesright.values()) {
                ArrayList<Node> arrayList = node.getActiveAdjacentNodes();
                fileWriter.write("R" + node.label + " :");
                for (Node node2 : arrayList) {
                    fileWriter.write(" + 1 " + node2.label.replace('|', 'X'));
                }
                fileWriter.write(" >= 1;\n");
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Could not write OPB-file " + string + " because" + exception.getMessage());
        }
    }

    public void toSetCoverCPLEXStream(String string, int n) {
        try {
            Object object;
            System.out.println("Writing LP file " + string);
            FileWriter fileWriter = new FileWriter(new File(string));
            fileWriter.write("Minimize \n");
            fileWriter.write(" covering: ");
            Iterator<Node> iterator = this.nodesleft.values().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                fileWriter.write("x('" + ((Node)object).label.replace('|', 'X') + "')");
                if (!iterator.hasNext()) continue;
                fileWriter.write(" + ");
            }
            fileWriter.write("\n");
            fileWriter.write("\n");
            object = this.nodesright.values().iterator();
            fileWriter.write("Subject To\n");
            while (object.hasNext()) {
                Node node = (Node)object.next();
                ArrayList<Node> arrayList = node.getActiveAdjacentNodes();
                System.out.println(arrayList.size());
                fileWriter.write(" completeness(" + node.label + ") :");
                for (Node node2 : arrayList) {
                    fileWriter.write(" + x('" + node2.label.replace('|', 'X') + "')");
                }
                fileWriter.write(" >= 1\n");
            }
            fileWriter.write("\n");
            fileWriter.write("BINARY\n");
            for (Node node : this.nodesleft.values()) {
                fileWriter.write("\t x('" + node.label.replace('|', 'X') + "')\n");
            }
            fileWriter.write("end\n");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Could not write LP-file " + string + " because" + exception.getMessage());
        }
    }

    public boolean isValidCovering(ArrayList<Node> arrayList) {
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        for (Node node : arrayList) {
            arrayList2.addAll(node.getAdjacentNodes());
        }
        boolean bl = arrayList2.containsAll(this.nodesright.values());
        return bl;
    }

    public ArrayList<Node> sortCovering(ArrayList<Node> arrayList, String string) {
        ArrayList<Node> arrayList2 = new ArrayList<Node>(arrayList);
        HashSet<Node> hashSet = new HashSet<Node>();
        ActiveCardinalityComparator activeCardinalityComparator = new ActiveCardinalityComparator();
        for (Node object : arrayList2) {
            object.setComparator(activeCardinalityComparator);
        }
        ArrayList arrayList3 = new ArrayList();
        try {
            FileWriter exception = new FileWriter(new File(string));
            while (!arrayList2.isEmpty()) {
                Node node = Collections.max(arrayList2);
                hashSet.addAll(node.getAdjacentNodes());
                exception.write(node.label + "\t" + hashSet.size() + "\t" + node.getActiveCardinality() + "\n");
                arrayList3.add(node);
                for (Node node2 : node.getAdjacentNodes()) {
                    node2.deactivateAllEdges();
                }
                arrayList2.remove(node);
                node.deactivateAllEdges();
            }
            exception.flush();
            exception.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.reset();
        return arrayList3;
    }

    public ArrayList<Node> getLeftNodeWithCardinality(int n, int n2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this.nodesleft.values()) {
            int n3 = node.getCardinality();
            if (n3 < n || n3 > n2) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public ArrayList<Node> getRightNodeWithCardinality(int n, int n2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this.nodesright.values()) {
            int n3 = node.getCardinality();
            if (n3 < n || n3 > n2) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public ArrayList<Node> getLeftNodeWithActiveCardinality(int n, int n2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this.nodesleft.values()) {
            int n3 = node.getActiveCardinality();
            if (n3 < n || n3 > n2) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public ArrayList<Node> getRightNodeWithActiveCardinality(int n, int n2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this.nodesright.values()) {
            int n3 = node.getActiveCardinality();
            if (n3 < n || n3 > n2) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public ArrayList<Node> findSimilarLeftNodes(Node node) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = node.getActiveAdjacentNodes();
        for (Node node2 : this.nodesleft.values()) {
            if (!node2.getActiveAdjacentNodes().containsAll(arrayList2) || !arrayList2.containsAll(node2.getActiveAdjacentNodes())) continue;
            arrayList.add(node2);
        }
        arrayList.remove(node);
        return arrayList;
    }

    @Override
    public void toGML(String string) {
        try {
            FileWriter fileWriter = new FileWriter(new File(string));
            fileWriter.write(this.toGML());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Could not write GML-file " + string + " because" + exception.getMessage());
        }
    }

    @Override
    public ArrayList<Node> getNodeSet(String string) {
        String[] stringArray;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (String string2 : stringArray = string.split(" ")) {
            if (!this.nodesleft.containsKey(string2)) continue;
            arrayList.add(this.nodesleft.get(string2));
        }
        return arrayList;
    }

    public ArrayList<Node> getNodeSet(ArrayList<String> arrayList) {
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        for (String string : arrayList) {
            if (this.nodesleft.containsKey(string)) {
                arrayList2.add(this.nodesleft.get(string));
            }
            if (!this.nodesright.containsKey(string)) continue;
            arrayList2.add(this.nodesright.get(string));
        }
        return arrayList2;
    }

    public int getIndex(Node node) {
        ArrayList<Node> arrayList = new ArrayList<Node>(this.nodesleft.values());
        ArrayList<Node> arrayList2 = new ArrayList<Node>(this.nodesright.values());
        if (arrayList.contains(node)) {
            return arrayList.indexOf(node);
        }
        return arrayList.size() + arrayList2.indexOf(node);
    }

    public Node getNode(int n) {
        ArrayList<Node> arrayList = new ArrayList<Node>(this.nodesleft.values());
        ArrayList<Node> arrayList2 = new ArrayList<Node>(this.nodesright.values());
        if (n < arrayList.size()) {
            return arrayList.get(n);
        }
        return arrayList2.get(n - arrayList.size());
    }

    public static void main(String[] stringArray) {
        BipartiteGraph bipartiteGraph = new BipartiteGraph();
        bipartiteGraph.addEdgeSecure("A", "X");
        bipartiteGraph.addEdgeSecure("B", "X");
        bipartiteGraph.addEdgeSecure("A", "Y");
        bipartiteGraph.addEdgeSecure("B", "Y");
        bipartiteGraph.addEdgeSecure("B", "U");
        bipartiteGraph.addEdgeSecure("C", "X");
        bipartiteGraph.addEdgeSecure("C", "U");
        bipartiteGraph.addEdgeSecure("C", "Y");
        bipartiteGraph.addEdgeSecure("D", "V");
        System.out.println(bipartiteGraph.getSetCoverLinearProgram(1).convertToCPLEX());
        ArrayList<Node> arrayList = bipartiteGraph.solveCoveringProblemLP(SolverFactory.newDefault(), 1);
        if (bipartiteGraph.isValidCovering(arrayList)) {
            System.out.print("Is valid solution!!");
        }
    }

    @Override
    public HashMap<String, Node> getNodes() {
        HashMap<String, Node> hashMap = new HashMap<String, Node>();
        hashMap.putAll(this.nodesleft);
        hashMap.putAll(this.nodesright);
        return hashMap;
    }

    @Override
    public int getNumberNodes() {
        return this.nodesleft.size() + this.nodesright.size();
    }
}

