/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.constraints;

import scpsolver.constraints.LinearConstraint;
import scpsolver.constraints.LinearEqualsConstraint;
import scpsolver.constraints.StochasticAbstractConstraint;
import scpsolver.util.SparseVector;

public class StochasticEqualsConstraint
extends StochasticAbstractConstraint {
    public StochasticEqualsConstraint(double[][] dArray, double[] dArray2, double[] dArray3, String string) {
        super(dArray, dArray2, dArray3, string);
    }

    public StochasticEqualsConstraint(SparseVector[] sparseVectorArray, SparseVector sparseVector, double[] dArray, String string) {
        super(sparseVectorArray, sparseVector, dArray, string);
    }

    @Override
    public LinearConstraint[] getExtensiveForm() {
        LinearConstraint[] linearConstraintArray = new LinearConstraint[this.h.length];
        for (int i = 0; i < linearConstraintArray.length; ++i) {
            double[] dArray = new double[this.w.getSize() * linearConstraintArray.length + this.t[i].getSize()];
            System.arraycopy(this.t[i].get(), 0, dArray, 0, this.t[i].getSize());
            System.arraycopy(this.w.get(), 0, dArray, this.t[i].getSize() + i * this.w.getSize(), this.w.getSize());
            linearConstraintArray[i] = new LinearEqualsConstraint(dArray, this.h[i], this.name + " - Scenario " + (i + 1));
        }
        return linearConstraintArray;
    }

    @Override
    public boolean isSatisfiedBy(double[] dArray) {
        double[] dArray2 = new double[this.w.getSize()];
        for (int i = 0; i < this.h.length; ++i) {
            double[] dArray3 = new double[this.t[i].getSize()];
            System.arraycopy(dArray, this.w.getSize() + i * this.t[i].getSize(), dArray3, 0, this.t[i].getSize());
            if (Math.abs(this.w.dot(dArray2) + this.t[i].dot(dArray3) - this.h[i]) < Math.pow(10.0, -6.0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getRHS() {
        return 0.0;
    }
}

