/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.constraints;

import scpsolver.constraints.LinearConstraint;
import scpsolver.constraints.StochasticConstraint;
import scpsolver.util.SparseVector;

public abstract class StochasticAbstractConstraint
implements StochasticConstraint {
    protected SparseVector w;
    protected SparseVector[] t;
    protected double[] h;
    protected String name;

    protected StochasticAbstractConstraint(SparseVector[] sparseVectorArray, SparseVector sparseVector, double[] dArray, String string) {
        this.w = sparseVector;
        this.t = sparseVectorArray;
        this.h = dArray;
        this.name = string;
    }

    protected StochasticAbstractConstraint(double[][] dArray, double[] dArray2, double[] dArray3, String string) {
        this.w = new SparseVector(dArray2);
        this.t = new SparseVector[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            this.t[i] = new SparseVector(dArray[i]);
        }
        this.h = dArray3;
        this.name = string;
    }

    @Override
    public double[] getC() {
        return this.w.get();
    }

    @Override
    public SparseVector getCSparse() {
        return this.w;
    }

    @Override
    public abstract LinearConstraint[] getExtensiveForm();

    @Override
    public double[] getH() {
        return this.h;
    }

    @Override
    public double[][] getT() {
        double[][] dArrayArray = new double[this.t.length][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            dArrayArray[i] = this.t[i].get();
        }
        return dArrayArray;
    }

    @Override
    public SparseVector[] getTSparse() {
        return this.t;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public abstract boolean isSatisfiedBy(double[] var1);

    @Override
    public double getRHS() {
        return 0.0;
    }
}

