/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.constraints;

import scpsolver.constraints.QuadraticConstraint;
import scpsolver.qpsolver.QuadraticProgramSolver;
import scpsolver.util.Matrix;
import scpsolver.util.SparseMatrix;
import scpsolver.util.SparseVector;

public class QuadraticSmallerThanEqualsContraint
implements QuadraticConstraint {
    Matrix Q;
    SparseVector c;
    double t;
    String name;

    public QuadraticSmallerThanEqualsContraint(Matrix matrix, SparseVector sparseVector, double d, String string) {
        this.Q = matrix;
        this.c = sparseVector;
        this.t = d;
        this.name = string;
    }

    public QuadraticSmallerThanEqualsContraint(double[][] dArray, double[] dArray2, double d, String string) {
        this.Q = new SparseMatrix(dArray);
        this.c = new SparseVector(dArray2);
        this.t = d;
        this.name = string;
    }

    @Override
    public String getName() {
        return "name";
    }

    @Override
    public boolean isSatisfiedBy(double[] dArray) {
        SparseVector sparseVector = new SparseVector(dArray);
        Matrix matrix = sparseVector.transpose().times(this.Q).times(sparseVector).plus(this.c.transpose().times(sparseVector));
        return matrix.get(0, 0) <= this.t;
    }

    @Override
    public void addToQuadraticProgramSolver(QuadraticProgramSolver quadraticProgramSolver) {
        quadraticProgramSolver.addQuadraticSmallerThanEqualsContraint(this);
    }

    @Override
    public double[] getC() {
        return this.c.get();
    }

    @Override
    public Matrix getQ() {
        return this.Q;
    }

    @Override
    public double getT() {
        return this.t;
    }

    @Override
    public SparseVector getCSparse() {
        return this.c;
    }

    @Override
    public double getRHS() {
        return this.t;
    }
}

