/*
 * Decompiled with CFR 0.152.
 */
package scpsolver.constraints;

import scpsolver.constraints.Convertable;
import scpsolver.constraints.LinearConstraint;
import scpsolver.lpsolver.LinearProgramSolver;
import scpsolver.util.SparseVector;

public class LinearEqualsConstraint
implements LinearConstraint,
Convertable {
    SparseVector c;
    double t;
    String name;

    public LinearEqualsConstraint(SparseVector sparseVector, double d, String string) {
        this.c = sparseVector;
        this.t = d;
        this.name = string;
    }

    public LinearEqualsConstraint(double[] dArray, double d, String string) {
        this.c = new SparseVector(dArray);
        this.t = d;
        this.name = string;
    }

    public void setC(double[] dArray) {
        this.c = new SparseVector(dArray);
    }

    @Override
    public double[] getC() {
        return this.c.get();
    }

    @Override
    public double getT() {
        return this.t;
    }

    public void setT(double d) {
        this.t = d;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSatisfiedBy(double[] dArray) {
        return Math.abs(this.c.dot(dArray) - this.t) < Math.pow(10.0, -6.0);
    }

    @Override
    public void addToLinearProgramSolver(LinearProgramSolver linearProgramSolver) {
        linearProgramSolver.addEqualsConstraint(this);
    }

    @Override
    public StringBuffer convertToCPLEX() {
        StringBuffer stringBuffer = new StringBuffer(" " + this.name.replace(" ", "_") + ": ");
        boolean bl = Boolean.TRUE;
        for (int n : this.c.getIndex()) {
            if (bl) {
                bl = Boolean.FALSE;
                if (this.c.get(n) == 1.0) {
                    stringBuffer.append("x" + n);
                    continue;
                }
                if (this.c.get(n) < 0.0) {
                    stringBuffer.append(this.c.get(n) + " x" + n);
                    continue;
                }
                stringBuffer.append(this.c.get(n) + " x" + n);
                continue;
            }
            if (this.c.get(n) == 1.0) {
                stringBuffer.append(" + x" + n);
                continue;
            }
            if (this.c.get(n) < 0.0) {
                stringBuffer.append(" " + this.c.get(n) + " x" + n);
                continue;
            }
            stringBuffer.append(" + " + this.c.get(n) + " x" + n);
        }
        stringBuffer.append(" = " + this.t);
        stringBuffer.append("\n");
        return stringBuffer;
    }

    @Override
    public StringBuffer convertToGMPL() {
        StringBuffer stringBuffer = new StringBuffer("subject to " + this.name + ": ");
        for (int n : this.c.getIndex()) {
            stringBuffer.append(this.c.get(n) + " * x" + n + " + ");
        }
        stringBuffer.delete(stringBuffer.lastIndexOf("+"), stringBuffer.length());
        stringBuffer.append(" = " + this.t + ";\n");
        return stringBuffer;
    }

    @Override
    public SparseVector getCSparse() {
        return this.c.clone();
    }

    @Override
    public double getRHS() {
        return this.t;
    }
}

