/*
 * Decompiled with CFR 0.152.
 */
package nmi.tools;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import nmi.tools.PeptideTools;
import scpsolver.constraints.LinearBiggerThanEqualsConstraint;
import scpsolver.constraints.LinearSmallerThanEqualsConstraint;
import scpsolver.lpsolver.LinearProgramSolver;
import scpsolver.lpsolver.SolverFactory;
import scpsolver.problems.LinearProgram;

public class Sequencer {
    char[] letters;
    double[] weights;

    public Sequencer() {
        HashMap<Character, Double> hashMap = new HashMap<Character, Double>();
        hashMap.put(Character.valueOf('A'), 71.09);
        hashMap.put(Character.valueOf('L'), 113.16999999999999);
        hashMap.put(Character.valueOf('R'), 156.2);
        hashMap.put(Character.valueOf('K'), 128.19);
        hashMap.put(Character.valueOf('N'), 114.12);
        hashMap.put(Character.valueOf('M'), 131.21);
        hashMap.put(Character.valueOf('D'), 115.1);
        hashMap.put(Character.valueOf('F'), 147.19);
        hashMap.put(Character.valueOf('C'), 160.15);
        hashMap.put(Character.valueOf('P'), 97.13);
        hashMap.put(Character.valueOf('Q'), 128.15);
        hashMap.put(Character.valueOf('S'), 87.09);
        hashMap.put(Character.valueOf('E'), 129.13);
        hashMap.put(Character.valueOf('T'), 101.12);
        hashMap.put(Character.valueOf('G'), 57.06999999999999);
        hashMap.put(Character.valueOf('W'), 186.24);
        hashMap.put(Character.valueOf('H'), 137.16);
        hashMap.put(Character.valueOf('Y'), 163.19);
        hashMap.put(Character.valueOf('I'), 113.16999999999999);
        hashMap.put(Character.valueOf('V'), 99.15);
        Set set = hashMap.keySet();
        this.letters = new char[20];
        this.weights = new double[20];
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            char c;
            this.letters[n] = c = ((Character)iterator.next()).charValue();
            this.weights[n] = (Double)hashMap.get(Character.valueOf(c));
            ++n;
        }
    }

    public String sequence(double[] dArray) {
        int n;
        double d = 0.1;
        LinearProgram linearProgram = new LinearProgram(this.weights);
        for (int i = 0; i < this.weights.length; ++i) {
            linearProgram.setInteger(i);
            double[] dArray2 = new double[this.weights.length];
            dArray2[i] = 1.0;
            linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(dArray2, 0.0, this.letters[i] + "_zeropositive"));
        }
        double[] dArray3 = new double[this.weights.length];
        for (n = 0; n < dArray3.length; ++n) {
            dArray3[n] = this.weights[n];
        }
        for (n = 0; n < dArray.length; ++n) {
            linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(dArray3, dArray[n] - d - 18.0, "lowerbound"));
            linearProgram.addConstraint(new LinearSmallerThanEqualsConstraint(dArray3, dArray[n] + d - 18.0, "upperbound"));
        }
        LinearProgramSolver linearProgramSolver = SolverFactory.newDefault();
        double[] dArray4 = linearProgramSolver.solve(linearProgram);
        for (int i = 0; i < dArray4.length; ++i) {
            if (!(dArray4[i] > 0.9)) continue;
            System.out.println("RESULT = " + this.letters[i] + ": " + dArray4[i]);
        }
        return null;
    }

    public static void main(String[] stringArray) {
        Sequencer sequencer = new Sequencer();
        sequencer.sequence(new double[]{PeptideTools.getWeight("RLSGK"), PeptideTools.getWeight("LSGK")});
    }
}

