/*
 * Decompiled with CFR 0.152.
 */
package nmi.assayoptimization;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class SimpleQueue<E extends Comparable<? super E>>
extends AbstractQueue<E> {
    HashMap<E, HashSet<E>> positions;
    TreeMap<E, HashSet<E>> slots = new TreeMap();
    HashSet<E> headkeys;
    int size = 0;

    public SimpleQueue() {
        this.positions = new HashMap();
        this.headkeys = new HashSet();
    }

    @Override
    public Iterator<E> iterator() {
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean offer(E e) {
        HashSet<E> hashSet = this.slots.get(e);
        if (hashSet == null) {
            hashSet = new HashSet();
            this.headkeys.add(e);
            this.slots.put(e, hashSet);
        }
        hashSet.add(e);
        this.positions.put(e, hashSet);
        ++this.size;
        return true;
    }

    @Override
    public E peek() {
        HashSet<E> hashSet = this.slots.lastEntry().getValue();
        Comparable comparable = (Comparable)this.slots.lastEntry().getKey();
        return (E)comparable;
    }

    @Override
    public E poll() {
        Comparable comparable;
        Map.Entry<E, HashSet<E>> entry = this.slots.pollLastEntry();
        HashSet<E> hashSet = entry.getValue();
        if (!hashSet.remove(comparable = (Comparable)entry.getKey())) {
            System.out.println("Top Element " + comparable + " not removed from slot!!");
        }
        this.headkeys.remove(comparable);
        if (this.slots.containsKey(comparable)) {
            System.out.println("Key " + comparable + " still in TreeMAP!");
        }
        this.positions.remove(comparable);
        if (!hashSet.isEmpty()) {
            Comparable comparable2 = (Comparable)hashSet.toArray()[0];
            this.slots.put(comparable2, hashSet);
            this.headkeys.add(comparable2);
        } else {
            System.out.println("Slot is empty!");
            if (this.slots.containsValue(hashSet)) {
                System.out.println("Slot still in treemap!");
            } else {
                System.out.println("Slot removed!");
            }
        }
        System.out.println("After POLL:" + this.peek());
        this.printSlotSizes();
        --this.size;
        return (E)comparable;
    }

    public void update(Collection<E> collection) {
        HashSet<E> hashSet;
        System.out.println("HEADKEYS BEFORE" + this.headkeys.size() + " SLOTS " + this.slots.size());
        for (Comparable comparable : collection) {
            hashSet = this.positions.get(comparable);
            try {
                hashSet.remove(comparable);
                --this.size;
            }
            catch (NullPointerException nullPointerException) {
                System.out.println(nullPointerException);
                System.out.println("ELEMENT:" + comparable);
                System.exit(-1);
            }
        }
        System.out.println("HEADKEYS AFTER DELETING ELEMENTS " + this.headkeys.size() + " SLOTS " + this.slots.size());
        for (Comparable comparable : collection) {
            if (!this.headkeys.remove(comparable)) continue;
            System.out.println("HEADKEYS " + this.headkeys.size() + " SLOTS " + this.slots.size());
            hashSet = this.positions.get(comparable);
            this.slots.remove(comparable);
            System.out.println(comparable + " was top element! Have to replace it!");
            if (!hashSet.isEmpty()) {
                Comparable comparable2 = (Comparable)hashSet.toArray()[0];
                this.headkeys.add(comparable2);
                if (this.slots.containsKey(comparable2)) {
                    System.out.println("!!treemap already contains " + comparable2);
                    for (Comparable comparable3 : collection) {
                        if (comparable2.compareTo(comparable3) != 0) continue;
                        System.out.println("Updated headkey item " + comparable3 + " equals " + comparable2);
                    }
                }
                this.slots.put(comparable2, hashSet);
                System.out.println("new head is: " + comparable2);
            } else {
                System.out.println("Slot was empty -> removing it");
            }
            System.out.println("=> HEADKEYS " + this.headkeys.size() + " SLOTS " + this.slots.size());
        }
        for (Comparable comparable : collection) {
            this.offer((E)comparable);
            System.out.println("AFTER OFFERING " + comparable + " HEADKEYS" + this.headkeys.size() + " SLOTS " + this.slots.size());
        }
        System.out.println("HEADKEYS AFTER" + this.headkeys.size() + " SLOTS " + this.slots.size());
        System.out.println("UPDATED");
    }

    public void printSlotSizes() {
        System.out.println("QueueSize: " + this.size);
        ArrayList<E> arrayList = new ArrayList<E>(this.slots.keySet());
        ArrayList<HashSet<E>> arrayList2 = new ArrayList<HashSet<E>>(this.slots.values());
        int n = 0;
        int n2 = 0;
        for (HashSet<E> hashSet : arrayList2) {
            if (++n2 <= arrayList2.size() - 5) continue;
            System.out.print(arrayList.get(n2 - 1) + " " + hashSet.size() + " -> ");
            for (Comparable comparable : hashSet) {
                System.out.print(comparable + " ");
            }
            System.out.println();
            n += hashSet.size();
        }
    }
}

