/*
 * Decompiled with CFR 0.152.
 */
package nmi.assayoptimization;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import nmi.assayoptimization.AntiBodyNode;
import nmi.assayoptimization.EdgeCollectionNode;
import nmi.assayoptimization.MarkedAntiBodyNodesComparator;
import nmi.assayoptimization.SlotQueue;
import nmi.assayoptimization.SubsetSelector;
import nmi.tools.PeptideTools;
import scpsolver.constraints.LinearBiggerThanEqualsConstraint;
import scpsolver.graph.ActiveCardinalityComparator;
import scpsolver.graph.BipartiteGraph;
import scpsolver.graph.Edge;
import scpsolver.graph.Graph;
import scpsolver.graph.Node;
import scpsolver.lpsolver.LinearProgramSolver;
import scpsolver.lpsolver.SolverFactory;
import scpsolver.problems.LinearProgram;
import scpsolver.util.SparseVector;

public class SandwichProteinCovering {
    BipartiteGraph abgraph;
    BipartiteGraph peptidegraph;

    public static void writeList(ArrayList<String> arrayList, String string) {
        try {
            FileWriter fileWriter = new FileWriter(new File(string));
            for (String string2 : arrayList) {
                fileWriter.write(string2 + "\n");
            }
            fileWriter.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reset() {
        this.abgraph.activateAllEdges();
        this.peptidegraph.activateAllEdges();
    }

    public static ArrayList<String> readList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            if (bufferedReader == null) {
                System.exit(-1);
            }
            String string2 = "";
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                string2 = string2.trim();
                arrayList.add(string2);
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            System.out.print("Cannot read line in file " + string);
        }
        return arrayList;
    }

    private static void addAntibodiesToGraph(BipartiteGraph bipartiteGraph, String string, int n, int n2, int n3) {
        File file = new File(string);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (Exception exception) {
            System.out.print("Cannot read file " + string);
        }
        if (bufferedReader == null) {
            System.exit(-1);
        }
        String string2 = "";
        try {
            string2 = bufferedReader.readLine();
        }
        catch (Exception exception) {
            System.out.print("Cannot first line in file " + string);
        }
        MarkedAntiBodyNodesComparator markedAntiBodyNodesComparator = new MarkedAntiBodyNodesComparator(n2, n3);
        while (string2 != null) {
            String[] stringArray = string2.split("\t");
            if (stringArray[0].length() >= n) {
                String string3 = "";
                int n4 = Integer.parseInt(stringArray[2].substring(1, 2));
                if (stringArray[2].charAt(0) == 'N') {
                    string3 = "|" + stringArray[0].substring(0, n4);
                    bipartiteGraph.addLeftNode(new AntiBodyNode(string3, markedAntiBodyNodesComparator));
                } else {
                    string3 = stringArray[0].substring(stringArray[0].length() - n4) + "|";
                    bipartiteGraph.addRightNode(new AntiBodyNode(string3, markedAntiBodyNodesComparator));
                }
            }
            try {
                string2 = bufferedReader.readLine();
            }
            catch (Exception exception) {
                System.out.print("Cannot first line in file " + string);
            }
        }
    }

    private static void addPeptidesToGraph(BipartiteGraph bipartiteGraph, String string, int n) {
        File file = new File(string);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (Exception exception) {
            System.out.print("Cannot read file " + string);
        }
        if (bufferedReader == null) {
            System.exit(-1);
        }
        String string2 = "";
        try {
            string2 = bufferedReader.readLine();
        }
        catch (Exception exception) {
            System.out.print("Cannot first line in file " + string);
        }
        while (string2 != null) {
            String[] stringArray = string2.split("\t");
            if (stringArray[0].length() >= n) {
                String string3 = stringArray[1];
                EdgeCollectionNode edgeCollectionNode = new EdgeCollectionNode(stringArray[0]);
                bipartiteGraph.addLeftNode(edgeCollectionNode);
                if (!bipartiteGraph.hasEdge(stringArray[0], string3)) {
                    bipartiteGraph.addEdgeSecure(stringArray[0], string3);
                }
            }
            try {
                string2 = bufferedReader.readLine();
            }
            catch (Exception exception) {
                System.out.print("Cannot first line in file " + string);
            }
        }
    }

    private static void addTerminiToGraph(BipartiteGraph bipartiteGraph, String string, int n) {
        File file = new File(string);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (Exception exception) {
            System.out.print("Cannot read file " + string);
        }
        if (bufferedReader == null) {
            System.exit(-1);
        }
        String string2 = "";
        try {
            string2 = bufferedReader.readLine();
        }
        catch (Exception exception) {
            System.out.print("Cannot first line in file " + string);
        }
        while (string2 != null) {
            String[] stringArray = string2.split("\t");
            if (stringArray[0].length() >= n) {
                String string3 = stringArray[1];
                bipartiteGraph.addEdgeSecure(stringArray[0], stringArray[2]);
            }
            try {
                string2 = bufferedReader.readLine();
            }
            catch (Exception exception) {
                System.out.print("Cannot first line in file " + string);
            }
        }
    }

    private static ArrayList<String> getDoublets(ArrayList<String> arrayList) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String string : arrayList) {
            if (hashSet2.add(string)) continue;
            hashSet.add(string);
        }
        return new ArrayList<String>(hashSet);
    }

    public static String getAbFromSequenceAndSignature(String string, String string2) {
        int n = Integer.parseInt(string2.substring(1, 2));
        String string3 = "";
        string3 = string2.charAt(0) == 'N' ? "|" + string.substring(0, n) : string.substring(string.length() - n) + "|";
        return string3;
    }

    public void buildGraphs(int n, int n2, int n3, int n4, String string, String string2) {
        this.abgraph = new BipartiteGraph();
        this.peptidegraph = new BipartiteGraph();
        System.gc();
        System.out.println("initializing termini matching graph... adding capture termini\n");
        SandwichProteinCovering.addAntibodiesToGraph(this.abgraph, string, n2, n3, n4);
        System.out.println("initializing termini matching graph... adding mark termini\n");
        SandwichProteinCovering.addAntibodiesToGraph(this.abgraph, string2, n2, n3, n4);
        System.out.println("building peptide-protein graph ...\n");
        SandwichProteinCovering.addPeptidesToGraph(this.peptidegraph, string, n2);
        System.out.println("building termini matching graph ...adding edges\n");
        BipartiteGraph bipartiteGraph = new BipartiteGraph();
        BipartiteGraph bipartiteGraph2 = new BipartiteGraph();
        SandwichProteinCovering.addTerminiToGraph(bipartiteGraph, string, n2);
        SandwichProteinCovering.addTerminiToGraph(bipartiteGraph2, string2, n2);
        HashMap<String, Node> hashMap = bipartiteGraph.getNodesleft();
        int n5 = hashMap.keySet().size();
        System.out.println("adding " + n5 + " peptides ...\n");
        for (String string3 : hashMap.keySet()) {
            Edge edge;
            String string4;
            String string5;
            String string6;
            String string7;
            ArrayList<Node> arrayList = hashMap.get(string3).getAdjacentNodes();
            ArrayList<Node> arrayList2 = bipartiteGraph2.getNodesleft().get(string3).getAdjacentNodes();
            for (Node node : arrayList) {
                string7 = node.getLabel();
                if (string7.charAt(0) != 'N') continue;
                string6 = SandwichProteinCovering.getAbFromSequenceAndSignature(string3, string7);
                for (Node node2 : arrayList2) {
                    string5 = node2.getLabel();
                    if (string5.charAt(0) != 'C') continue;
                    string4 = SandwichProteinCovering.getAbFromSequenceAndSignature(string3, string5);
                    edge = this.abgraph.addEdgeSecure(string6, string4, string3, false);
                    ((EdgeCollectionNode)this.peptidegraph.getNodesleft().get(string3)).addCEdge(edge);
                }
            }
            for (Node node : arrayList) {
                string7 = node.getLabel();
                if (string7.charAt(0) != 'C') continue;
                string6 = SandwichProteinCovering.getAbFromSequenceAndSignature(string3, string7);
                for (Node node2 : arrayList2) {
                    string5 = node2.getLabel();
                    if (string5.charAt(0) != 'N') continue;
                    string4 = SandwichProteinCovering.getAbFromSequenceAndSignature(string3, string5);
                    edge = this.abgraph.addEdgeSecure(string4, string6, string3, true);
                    ((EdgeCollectionNode)this.peptidegraph.getNodesleft().get(string3)).addCEdge(edge);
                }
            }
        }
    }

    public void disableShortEdges(int n) {
        System.out.println("disabling edges that are to short..\n");
        HashMap<String, Node> hashMap = this.peptidegraph.getNodesleft();
        for (Node node : hashMap.values()) {
            ArrayList<Edge> arrayList;
            if (node.getLabel().length() < n) {
                node.deactivateAllEdges();
                arrayList = ((EdgeCollectionNode)node).getEdgecollection();
                for (Edge edge : arrayList) {
                    edge.setActive(false);
                }
                continue;
            }
            arrayList = ((EdgeCollectionNode)node).getEdgecollection();
            boolean bl = false;
            for (Edge edge : arrayList) {
                if (!edge.isActive()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            node.deactivateAllEdges();
        }
    }

    public void disableDuplicates() {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        ArrayList<Node> arrayList3;
        System.out.println("disabling non-unique combinations...\n");
        ArrayList<Node> arrayList4 = this.abgraph.getLeftNodeWithCardinality(2, 10000000);
        for (Node node : arrayList4) {
            arrayList3 = node.getOutboundNodes();
            arrayList2 = new ArrayList<String>();
            for (Node node2 : arrayList3) {
                arrayList2.add(node2.getLabel());
            }
            arrayList = SandwichProteinCovering.getDoublets(arrayList2);
            if (arrayList.isEmpty()) continue;
            for (String string : arrayList) {
                for (Edge edge : node.getEdgeList()) {
                    if (!edge.getNode2().getLabel().equals(string) || !edge.isActive()) continue;
                    edge.setActive(false);
                }
            }
        }
        arrayList4 = this.abgraph.getRightNodeWithCardinality(2, 10000000);
        for (Node node : arrayList4) {
            arrayList3 = node.getOutboundNodes();
            arrayList2 = new ArrayList();
            for (Node node3 : arrayList3) {
                arrayList2.add(node3.getLabel());
            }
            arrayList = SandwichProteinCovering.getDoublets(arrayList2);
            if (arrayList.isEmpty()) continue;
            for (String string : arrayList) {
                for (Edge edge : node.getEdgeList()) {
                    if (!edge.getNode2().getLabel().equals(string) || !edge.isActive()) continue;
                    edge.setActive(false);
                }
            }
        }
    }

    private ArrayList<Edge> getSimilarWeightEdges(ArrayList<Edge> arrayList, double d) {
        int n;
        HashSet<Edge> hashSet = new HashSet<Edge>();
        double[] dArray = new double[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            dArray[n] = PeptideTools.getWeight(arrayList.get(n).getLabel());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            for (int i = n + 1; i < arrayList.size(); ++i) {
                if (!(Math.abs(dArray[n] - dArray[i]) < d)) continue;
                hashSet.add(arrayList.get(n));
                hashSet.add(arrayList.get(i));
            }
        }
        return new ArrayList<Edge>(hashSet);
    }

    public void disableDuplicatesWithSimilarWeight(double d) {
        Edge edge;
        Object object;
        ArrayList<Edge> arrayList;
        ArrayList<String> arrayList2;
        ArrayList<String> arrayList3;
        ArrayList<Node> arrayList4;
        System.out.println("disabling peptides with same terminal combinations that have a very similar molecular mass...\n");
        ArrayList<Node> arrayList5 = this.abgraph.getLeftNodeWithCardinality(2, 10000000);
        for (Node node : arrayList5) {
            arrayList4 = node.getOutboundNodes();
            arrayList3 = new ArrayList<String>();
            for (Node node2 : arrayList4) {
                arrayList3.add(node2.getLabel());
            }
            arrayList2 = SandwichProteinCovering.getDoublets(arrayList3);
            if (arrayList2.isEmpty()) continue;
            for (String string : arrayList2) {
                arrayList = new ArrayList<Edge>();
                for (Edge edge2 : node.getEdgeList()) {
                    if (!edge2.getNode2().getLabel().equals(string) || !edge2.isActive()) continue;
                    arrayList.add(edge2);
                }
                object = this.getSimilarWeightEdges(arrayList, d);
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    edge = (Edge)iterator.next();
                    edge.setActive(false);
                }
            }
        }
        arrayList5 = this.abgraph.getRightNodeWithCardinality(2, 10000000);
        for (Node node : arrayList5) {
            arrayList4 = node.getOutboundNodes();
            arrayList3 = new ArrayList();
            for (Node node3 : arrayList4) {
                arrayList3.add(node3.getLabel());
            }
            arrayList2 = SandwichProteinCovering.getDoublets(arrayList3);
            if (arrayList2.isEmpty()) continue;
            for (String string : arrayList2) {
                arrayList = new ArrayList();
                for (Edge edge3 : node.getEdgeList()) {
                    if (!edge3.getNode2().getLabel().equals(string) || !edge3.isActive()) continue;
                    arrayList.add(edge3);
                }
                object = this.getSimilarWeightEdges(arrayList, d);
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    edge = (Edge)iterator.next();
                    edge.setActive(false);
                }
            }
        }
    }

    public Graph getTerminiSharingGraph() {
        Graph graph = new Graph();
        ArrayList<Node> arrayList = new ArrayList<Node>(this.abgraph.getNodesleft().values());
        arrayList.addAll(this.abgraph.getNodesright().values());
        for (Node node : arrayList) {
            HashSet<Node> hashSet = new HashSet<Node>();
            ArrayList<Edge> arrayList2 = node.getEdgeList();
            for (Edge edge : arrayList2) {
                if (!edge.isActive()) continue;
                String string = edge.getLabel();
                Node node2 = this.peptidegraph.getNodesleft().get(string);
                ArrayList<Node> arrayList3 = node2.getOutboundNodes();
                hashSet.addAll(arrayList3);
            }
            for (Node node3 : hashSet) {
                for (Node node2 : hashSet) {
                    if (node3.getLabel().equals(node2.getLabel()) || !(!graph.hasEdge(node3.getLabel(), node2.getLabel()) & !graph.hasEdge(node2.getLabel(), node3.getLabel()))) continue;
                    graph.addEdgeSecure(node3.getLabel(), node2.getLabel());
                }
            }
        }
        return graph;
    }

    public BipartiteGraph getTerminiSharingBiGraph() {
        BipartiteGraph bipartiteGraph = new BipartiteGraph();
        ArrayList<Node> arrayList = new ArrayList<Node>(this.abgraph.getNodesleft().values());
        arrayList.addAll(this.abgraph.getNodesright().values());
        for (Node node : arrayList) {
            HashSet<Node> hashSet = new HashSet<Node>();
            ArrayList<Edge> arrayList2 = node.getEdgeList();
            for (Edge edge : arrayList2) {
                if (!edge.isActive()) continue;
                String string = edge.getLabel();
                Node node2 = this.peptidegraph.getNodesleft().get(string);
                ArrayList<Node> arrayList3 = node2.getOutboundNodes();
                hashSet.addAll(arrayList3);
            }
            for (Node node3 : hashSet) {
                for (Node node2 : hashSet) {
                    if (node3.getLabel().equals(node2.getLabel()) || !(!bipartiteGraph.hasEdge(node3.getLabel(), node2.getLabel()) & !bipartiteGraph.hasEdge(node2.getLabel(), node3.getLabel()))) continue;
                    bipartiteGraph.addEdgeSecure(node3.getLabel(), node2.getLabel());
                }
            }
        }
        return bipartiteGraph;
    }

    public ArrayList<String> toLabelList(ArrayList<Node> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Node node : arrayList) {
            arrayList2.add(node.getLabel());
        }
        return arrayList2;
    }

    public ArrayList<String> optimize() {
        Object object2;
        HashSet<Object> hashSet;
        AbstractCollection abstractCollection;
        ArrayList<String> arrayList = new ArrayList<String>();
        System.out.println("starting heuristics... \n");
        HashMap<String, Node> hashMap = this.peptidegraph.getNodesright();
        for (Node object22 : hashMap.values()) {
            abstractCollection = object22.getInboundNodes();
            hashSet = new HashSet<Object>();
            for (Object object2 : abstractCollection) {
                ArrayList<Edge> n = ((EdgeCollectionNode)object2).getEdgecollection();
                for (Edge edge : n) {
                    if (!edge.isActive()) continue;
                    hashSet.add(edge.getNode1());
                }
            }
            for (Object object2 : hashSet) {
                ((AntiBodyNode)object2).incNewproteinscaptured();
            }
        }
        ArrayList<Node> arrayList3 = new ArrayList<Node>(this.abgraph.getNodesleft().values());
        arrayList3.addAll(this.abgraph.getNodesright().values());
        HashSet<String> hashSet2 = new HashSet<String>();
        abstractCollection = new HashSet();
        hashSet = new HashSet();
        ArrayList arrayList2 = new ArrayList();
        object2 = new HashSet();
        int n = this.peptidegraph.getRightNodeWithActiveCardinality(1, 100000000).size();
        System.out.println("Identifiable proteins: " + n + "\n");
        SlotQueue slotQueue = new SlotQueue();
        slotQueue.addAll(arrayList3);
        while (((HashSet)abstractCollection).size() < n) {
            Object object3;
            ArrayList<Node> arrayList4;
            boolean bl;
            ArrayList<Node> arrayList5;
            AntiBodyNode antiBodyNode = (AntiBodyNode)slotQueue.poll();
            HashSet<Object> hashSet3 = new HashSet<Object>();
            hashSet.add(antiBodyNode.getLabel());
            ArrayList<Edge> arrayList6 = antiBodyNode.getEdgeList();
            for (Edge edge : arrayList6) {
                if (!(edge.isActive() & edge.getNode1() == antiBodyNode)) continue;
                arrayList5 = this.peptidegraph.getNodesleft().get(edge.getLabel()).getActiveAdjacentNodes();
                for (Node node : arrayList5) {
                    bl = hashSet2.add(node.getLabel());
                    if (!bl) continue;
                    arrayList4 = node.getInboundNodes();
                    Iterator<Node> iterator = new HashSet();
                    for (Node node2 : arrayList4) {
                        Iterator<Edge> iterator2 = ((EdgeCollectionNode)node2).getEdgecollection();
                        Iterator<Edge> iterator3 = ((ArrayList)((Object)iterator2)).iterator();
                        while (iterator3.hasNext()) {
                            object3 = iterator3.next();
                            AntiBodyNode antiBodyNode2 = (AntiBodyNode)((Edge)object3).getNode1();
                            if (((Edge)object3).isActive() && antiBodyNode2.getNewproteinscaptured() > 0 && ((HashSet)((Object)iterator)).add(antiBodyNode2)) {
                                antiBodyNode2.decNewproteinscaptured();
                            }
                            hashSet3.add(antiBodyNode2);
                        }
                    }
                }
                ((AntiBodyNode)edge.getNode2()).incNewproteinsmarked();
                hashSet3.add((AntiBodyNode)edge.getNode2());
            }
            for (Edge edge : arrayList6) {
                if (!(edge.isActive() & edge.getNode2() == antiBodyNode)) continue;
                arrayList5 = this.peptidegraph.getNodesleft().get(edge.getLabel()).getActiveAdjacentNodes();
                for (Node node : arrayList5) {
                    if (!hashSet.contains(edge.getNode1().getLabel())) continue;
                    if (((HashSet)object2).add(edge.getNode1().getLabel())) {
                        arrayList.add(edge.getNode1().getLabel());
                    }
                    if (((HashSet)object2).add(edge.getNode2().getLabel())) {
                        arrayList.add(edge.getNode2().getLabel());
                    }
                    if (!(bl = ((HashSet)abstractCollection).add(node.getLabel()))) continue;
                    arrayList4 = node.getInboundNodes();
                    for (Node node3 : arrayList4) {
                        ArrayList<Edge> arrayList7 = ((EdgeCollectionNode)node3).getEdgecollection();
                        for (Edge edge2 : arrayList7) {
                            object3 = (AntiBodyNode)edge2.getNode2();
                            if (hashSet.contains(edge2.getNode1().getLabel()) && edge2.isActive() && ((AntiBodyNode)object3).getNewproteinsmarked() > 0) {
                                ((AntiBodyNode)object3).decNewproteinsmarked();
                                hashSet3.add(object3);
                            }
                            edge2.setActive(false);
                        }
                    }
                    node.deactivateAllEdges();
                }
            }
            for (Edge edge : arrayList6) {
                if (!(edge.isActive() & edge.getNode1() == antiBodyNode)) continue;
                arrayList5 = this.peptidegraph.getNodesleft().get(edge.getLabel()).getActiveAdjacentNodes();
                for (Node node : arrayList5) {
                    boolean bl2;
                    ArrayList<Node> arrayList8 = node.getInboundNodes();
                    if (!hashSet.contains(edge.getNode2().getLabel())) continue;
                    System.out.print("Already selected antibody " + edge.getNode2().getLabel() + " marks ");
                    System.out.println(edge.getLabel() + " in " + node.getLabel());
                    if (((HashSet)object2).add(edge.getNode1().getLabel())) {
                        arrayList.add(edge.getNode1().getLabel());
                    }
                    if (((HashSet)object2).add(edge.getNode2().getLabel())) {
                        arrayList.add(edge.getNode2().getLabel());
                    }
                    if (!(bl2 = ((HashSet)abstractCollection).add(node.getLabel()))) continue;
                    for (Node node4 : arrayList8) {
                        ArrayList<Edge> arrayList9 = ((EdgeCollectionNode)node4).getEdgecollection();
                        for (Edge edge3 : arrayList9) {
                            object3 = (AntiBodyNode)edge3.getNode2();
                            if (hashSet.contains(edge3.getNode1().getLabel()) && edge3.isActive() && ((AntiBodyNode)object3).getNewproteinsmarked() > 0) {
                                ((AntiBodyNode)object3).decNewproteinsmarked();
                                hashSet3.add(object3);
                            }
                            edge3.setActive(false);
                        }
                    }
                    node.deactivateAllEdges();
                }
            }
            arrayList2.add(((HashSet)abstractCollection).size() + "\t" + ((HashSet)object2).size() + "\t" + hashSet.size() + "\t" + hashSet2.size());
            hashSet3.remove(antiBodyNode);
            slotQueue.update(hashSet3);
        }
        System.out.println(((HashSet)object2).size() + " used antibodies");
        SandwichProteinCovering.writeList(new ArrayList<String>((Collection<String>)object2), "ablist.txt");
        SandwichProteinCovering.writeList(new ArrayList<String>(abstractCollection), "proteinlist.txt");
        SandwichProteinCovering.writeList(arrayList2, "log.txt");
        return arrayList;
    }

    public ArrayList<Node> getCoveredPeptides(ArrayList<String> arrayList) {
        Object object;
        HashSet<Node> hashSet = new HashSet<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        for (String object2 : arrayList) {
            object = this.abgraph.getNode(object2);
            arrayList2.add((Node)object);
        }
        for (Node node : arrayList2) {
            object = node.getEdgeList();
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                if (!arrayList2.contains(edge.getNode1()) || !arrayList2.contains(edge.getNode2())) continue;
                hashSet.add(this.peptidegraph.getNode(edge.getLabel()));
            }
        }
        return new ArrayList<Node>(hashSet);
    }

    public LinearProgram getLinearProgram() {
        ArrayList<Object> arrayList;
        Object object;
        ArrayList<Node> arrayList2 = new ArrayList<Node>(this.abgraph.getNodesleft().values());
        arrayList2.addAll(this.abgraph.getNodesright().values());
        System.out.println("All nodes " + arrayList2.size());
        int n = this.peptidegraph.getRightNodeWithActiveCardinality(1, 100000000).size();
        System.out.println("Identifiable proteins: " + n + "\n");
        HashMap<String, Node> hashMap = this.peptidegraph.getNodesright();
        HashMap<String, Node> hashMap2 = this.peptidegraph.getNodesleft();
        int n2 = arrayList2.size() + hashMap2.size();
        System.out.println("Dimension " + n2);
        SparseVector sparseVector = new SparseVector(n2, arrayList2.size());
        for (int i = 0; i < arrayList2.size(); ++i) {
            sparseVector.set(i, 1.0);
        }
        LinearProgram linearProgram = new LinearProgram(sparseVector);
        HashMap<Node, Integer> hashMap3 = new HashMap<Node, Integer>();
        Iterator<Node> iterator = hashMap2.values().iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            hashMap3.put(iterator.next(), n3++);
        }
        HashMap<Node, Integer> hashMap4 = new HashMap<Node, Integer>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            hashMap4.put(arrayList2.get(i), i);
        }
        for (Node node : hashMap.values()) {
            object = new SparseVector(n2, node.getActiveCardinality());
            arrayList = node.getActiveAdjacentNodes();
            if (arrayList.isEmpty()) continue;
            for (Object object2 : arrayList) {
                int n4 = (Integer)hashMap3.get(object2);
                System.out.print(n4 + " ");
                ((SparseVector)object).set(n4 + arrayList2.size(), 1.0);
            }
            System.out.println(" > 1");
            linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint((SparseVector)object, 1.0, "Protein " + node.getLabel() + " must be covered by at least 1 peptide"));
        }
        for (Node node : hashMap2.values()) {
            Object object2;
            object = (EdgeCollectionNode)node;
            arrayList = ((EdgeCollectionNode)object).getEdgecollection();
            if (arrayList.isEmpty()) continue;
            SparseVector sparseVector2 = new SparseVector(n2, 2);
            object2 = new SparseVector(n2, 2);
            SparseVector sparseVector3 = new SparseVector(n2, 2);
            int n5 = (Integer)hashMap3.get(node);
            sparseVector2.set(n5 + arrayList2.size(), -1.0);
            ((SparseVector)object2).set(n5 + arrayList2.size(), -1.0);
            sparseVector3.set(n5 + arrayList2.size(), -1.0);
            for (Edge edge : arrayList) {
                Node node2 = edge.getNode1();
                Node node3 = edge.getNode2();
                if (edge.getNode2().getLabel().startsWith("|")) {
                    node2 = edge.getNode2();
                    node3 = edge.getNode1();
                }
                sparseVector2.set((Integer)hashMap4.get(node2), 1.0);
                ((SparseVector)object2).set((Integer)hashMap4.get(node3), 1.0);
                sparseVector3.set((Integer)hashMap4.get(edge.getNode1()), 1.0);
            }
            linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(sparseVector2, 0.0, "N-term "));
            linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint((SparseVector)object2, 0.0, "C-term "));
            linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(sparseVector3, 0.0, "capture"));
        }
        for (int i = 0; i < n2; ++i) {
            linearProgram.setBinary(i);
        }
        linearProgram.setMinProblem(true);
        return linearProgram;
    }

    public ArrayList<Node> solveLinearProgramForSubProblem(ArrayList<Node> arrayList, ArrayList<Node> arrayList2, ArrayList<Node> arrayList3, LinearProgramSolver linearProgramSolver) {
        ArrayList<Object> arrayList4;
        Object object;
        Iterator<Edge> iterator;
        Cloneable cloneable;
        Object object2;
        ArrayList<Node> arrayList6 = new ArrayList<Node>();
        for (Node arrayList52 : arrayList) {
            arrayList6.addAll(arrayList52.getActiveAdjacentNodes());
        }
        HashSet hashSet = new HashSet();
        for (Node node : arrayList6) {
            object2 = (EdgeCollectionNode)node;
            cloneable = ((EdgeCollectionNode)object2).getEdgecollection();
            iterator = ((ArrayList)cloneable).iterator();
            while (iterator.hasNext()) {
                Edge edge = iterator.next();
                hashSet.add(edge.getNode1());
                hashSet.add(edge.getNode2());
            }
        }
        ArrayList arrayList5 = new ArrayList(hashSet);
        int n = hashSet.size() + arrayList6.size();
        System.out.println("Dimension " + n);
        object2 = new SparseVector(n, hashSet.size());
        cloneable = new HashMap();
        iterator = arrayList6.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            ((HashMap)cloneable).put((Node)((Object)iterator.next()), n2++);
        }
        HashMap hashMap = new HashMap();
        Iterator iterator2 = hashSet.iterator();
        n2 = 0;
        HashSet<Node> hashSet2 = new HashSet<Node>(arrayList3);
        hashSet2.removeAll(arrayList2);
        for (int i = 0; i < arrayList5.size(); ++i) {
            hashMap.put(arrayList5.get(i), n2++);
            if (hashSet2.contains(arrayList5.get(i))) continue;
            ((SparseVector)object2).set(i, 1.0);
        }
        LinearProgram linearProgram = new LinearProgram((SparseVector)object2);
        for (Node node : arrayList) {
            object = new SparseVector(n, node.getActiveCardinality());
            arrayList4 = node.getActiveAdjacentNodes();
            if (arrayList4.isEmpty()) continue;
            for (Object object3 : arrayList4) {
                int n3 = (Integer)((HashMap)cloneable).get(object3);
                ((SparseVector)object).set(n3 + hashSet.size(), 1.0);
            }
            linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint((SparseVector)object, 1.0, "Protein " + node.getLabel() + " must be covered by at least 1 peptide"));
        }
        for (Node node : arrayList6) {
            Object object3;
            object = (EdgeCollectionNode)node;
            arrayList4 = ((EdgeCollectionNode)object).getEdgecollection();
            if (arrayList4.isEmpty()) continue;
            SparseVector sparseVector = new SparseVector(n, 2);
            object3 = new SparseVector(n, 2);
            SparseVector sparseVector2 = new SparseVector(n, 2);
            int n4 = (Integer)((HashMap)cloneable).get(node);
            sparseVector.set(n4 + hashSet.size(), -1.0);
            ((SparseVector)object3).set(n4 + hashSet.size(), -1.0);
            sparseVector2.set(n4 + hashSet.size(), -1.0);
            for (Edge edge : arrayList4) {
                Node node2 = edge.getNode1();
                Node node3 = edge.getNode2();
                if (edge.getNode2().getLabel().startsWith("|")) {
                    node2 = edge.getNode2();
                    node3 = edge.getNode1();
                }
                sparseVector.set((Integer)hashMap.get(node2), 1.0);
                ((SparseVector)object3).set((Integer)hashMap.get(node3), 1.0);
                sparseVector2.set((Integer)hashMap.get(edge.getNode1()), 1.0);
            }
            linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(sparseVector, 0.0, "N-term "));
            linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint((SparseVector)object3, 0.0, "C-term "));
            linearProgram.addConstraint(new LinearBiggerThanEqualsConstraint(sparseVector2, 0.0, "capture"));
        }
        for (int i = 0; i < n; ++i) {
            linearProgram.setBinary(i);
        }
        linearProgram.setMinProblem(true);
        double[] dArray = linearProgramSolver.solve(linearProgram);
        ArrayList<Node> arrayList7 = new ArrayList<Node>();
        for (int i = 0; i < hashSet.size(); ++i) {
            if (!(dArray[i] > 0.99)) continue;
            arrayList7.add((Node)arrayList5.get(i));
        }
        return arrayList7;
    }

    public ArrayList<Node> localGRASP(ArrayList<String> arrayList, SubsetSelector subsetSelector) {
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        for (String object2 : arrayList) {
            arrayList2.add(this.abgraph.getNode(object2));
        }
        ArrayList<Node> arrayList3 = subsetSelector.selectSubset(arrayList2);
        HashSet<Node> hashSet = new HashSet<Node>(arrayList2);
        hashSet.removeAll(arrayList3);
        System.out.println("Identifiy proteins identified uniquely by least contributors...");
        ArrayList<Node> arrayList4 = this.getIdentifiedProteins(hashSet);
        ArrayList<Node> arrayList5 = this.peptidegraph.getRightNodeWithActiveCardinality(1, 10000000);
        arrayList5.removeAll(arrayList4);
        ArrayList<Node> arrayList6 = this.solveLinearProgramForSubProblem(arrayList5, arrayList3, arrayList2, SolverFactory.getSolver("CPLEX"));
        for (Node node : arrayList6) {
            if (hashSet.contains(node)) continue;
            hashSet.add(node);
        }
        return new ArrayList<Node>(hashSet);
    }

    public ArrayList<String> decodeSolution(double[] dArray) {
        ArrayList<Node> arrayList = new ArrayList<Node>(this.abgraph.getNodesleft().values());
        arrayList.addAll(this.abgraph.getNodesright().values());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!(dArray[i] > 0.999)) continue;
            arrayList2.add(arrayList.get(i).getLabel());
        }
        return arrayList2;
    }

    public double[] encodeSolution(ArrayList<String> arrayList) {
        ArrayList<Node> arrayList2 = new ArrayList<Node>(this.abgraph.getNodesleft().values());
        arrayList2.addAll(this.abgraph.getNodesright().values());
        System.out.println("All nodes " + arrayList2.size());
        int n = this.peptidegraph.getRightNodeWithActiveCardinality(1, 100000000).size();
        System.out.println("Identifiable proteins: " + n + "\n");
        HashMap<String, Node> hashMap = this.peptidegraph.getNodesright();
        HashMap<String, Node> hashMap2 = this.peptidegraph.getNodesleft();
        ArrayList<Node> arrayList3 = new ArrayList<Node>(hashMap2.values());
        int n2 = arrayList2.size() + hashMap2.size();
        double[] dArray = new double[n2];
        System.out.println("Encoding selected epitopes...");
        for (String string : arrayList) {
            int n3 = arrayList2.indexOf(this.abgraph.getNode(string));
            dArray[n3] = 1.0;
        }
        System.out.println("Encoding selected peptides...");
        ArrayList<Node> arrayList4 = this.getCoveredPeptides(arrayList);
        System.out.println("peptides: " + arrayList4.size());
        int n4 = arrayList2.size();
        Iterator iterator = arrayList4.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            int n5 = arrayList3.indexOf(node);
            dArray[n4 + n5] = 1.0;
        }
        return dArray;
    }

    public void deactivateAllButTheseProteins(ArrayList<String> arrayList) {
        HashMap<String, Node> hashMap = this.peptidegraph.getNodesright();
        for (Node node : hashMap.values()) {
            if (arrayList.contains(node.getLabel())) continue;
            ArrayList<Node> arrayList2 = node.getInboundNodes();
            for (Node node2 : arrayList2) {
                ArrayList<Edge> arrayList3 = ((EdgeCollectionNode)node2).getEdgecollection();
                for (Edge edge : arrayList3) {
                    edge.setActive(false);
                }
            }
            node.deactivateAllEdges();
        }
    }

    public ArrayList<String> optimizeSubset(ArrayList<String> arrayList) {
        this.deactivateAllButTheseProteins(arrayList);
        return this.optimize();
    }

    public ArrayList<Node> getIdentifiedProteins(Collection<Node> collection) {
        HashSet<Node> hashSet = new HashSet<Node>();
        for (Node node : collection) {
            ArrayList<Edge> arrayList = node.getEdgeList();
            for (Edge edge : arrayList) {
                Node node2 = edge.getNode1();
                if (node == node2) {
                    node2 = edge.getNode2();
                }
                if (!collection.contains(node2)) continue;
                ArrayList<Node> arrayList2 = this.peptidegraph.getNode(edge.getLabel()).getActiveAdjacentNodes();
                for (Node node3 : arrayList2) {
                    hashSet.add(node3);
                }
            }
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hashSet);
        return arrayList;
    }

    public boolean checkSolution(Collection<String> collection) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (String string : collection) {
            arrayList.add(this.abgraph.getNode(string));
        }
        ArrayList<Node> arrayList2 = this.getIdentifiedProteins(arrayList);
        return arrayList2.containsAll(this.peptidegraph.getRightNodeWithActiveCardinality(1, 100000000));
    }

    public void writeReport(ArrayList<String> arrayList, String string) {
        try {
            FileWriter fileWriter = new FileWriter(new File(string));
            fileWriter.write("<html><head>Sandwich Covering Report</head><body>");
            ArrayList<Node> arrayList2 = this.abgraph.getNodeSet(arrayList);
            System.out.print("Nodelist size: " + arrayList2.size());
            ActiveCardinalityComparator activeCardinalityComparator = new ActiveCardinalityComparator();
            for (Node node : arrayList2) {
                node.setComparator(activeCardinalityComparator);
            }
            Collections.sort(arrayList2);
            Collections.reverse(arrayList2);
            for (Node node : arrayList2) {
                ArrayList<Node> arrayList3;
                String string2 = node.getLabel();
                fileWriter.write("<h1>" + string2 + "</h1>");
                ArrayList<Edge> arrayList4 = node.getEdgeList();
                fileWriter.write("<b>captures</b>:\n<br>");
                for (Edge edge : arrayList4) {
                    if (!edge.isActive() || !(edge.getNode1() == node & arrayList.contains(edge.getNode2().getLabel()))) continue;
                    if (string2.startsWith("|")) {
                        fileWriter.write("<b style='color:blue'>" + string2 + "</b>");
                    } else {
                        fileWriter.write("<b style='color:red'>" + edge.getNode2().getLabel() + "</b>");
                    }
                    fileWriter.write(" <code>" + edge.getLabel().substring(0, 5) + "..." + edge.getLabel().substring(edge.getLabel().length() - 5) + "</code> ");
                    if (!string2.startsWith("|")) {
                        fileWriter.write("<b style='color:blue'>" + string2 + "</b>");
                    } else {
                        fileWriter.write("<b style='color:red'>" + edge.getNode2().getLabel() + "</b>");
                    }
                    arrayList3 = this.peptidegraph.getNodesleft().get(edge.getLabel()).getOutboundNodes();
                    for (Node node2 : arrayList3) {
                        fileWriter.write(" " + node2.getLabel());
                    }
                    fileWriter.write("<br>");
                }
                fileWriter.write("<b>identifies</b>:\n<br>");
                for (Edge edge : arrayList4) {
                    if (!edge.isActive() || !(edge.getNode2() == node & arrayList.contains(edge.getNode1().getLabel()))) continue;
                    if (string2.startsWith("|")) {
                        fileWriter.write("<b style='color:red'>" + string2 + "</b>");
                    } else {
                        fileWriter.write("<b style='color:blue'>" + edge.getNode1().getLabel() + "</b>");
                    }
                    fileWriter.write(" <code>" + edge.getLabel().substring(0, 5) + "..." + edge.getLabel().substring(edge.getLabel().length() - 5) + "</code> ");
                    if (!string2.startsWith("|")) {
                        fileWriter.write("<b style='color:red'>" + string2 + "</b>");
                    } else {
                        fileWriter.write("<b style='color:blue'>" + edge.getNode1().getLabel() + "</b>");
                    }
                    arrayList3 = this.peptidegraph.getNodesleft().get(edge.getLabel()).getOutboundNodes();
                    for (Node node2 : arrayList3) {
                        fileWriter.write(" " + node2.getLabel());
                    }
                    fileWriter.write("<br>");
                }
            }
            fileWriter.write("\n");
            fileWriter.write("</body></html>");
            fileWriter.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BipartiteGraph getAbgraph() {
        return this.abgraph;
    }

    public void setAbgraph(BipartiteGraph bipartiteGraph) {
        this.abgraph = bipartiteGraph;
    }

    public BipartiteGraph getPeptidegraph() {
        return this.peptidegraph;
    }

    public void setPeptidegraph(BipartiteGraph bipartiteGraph) {
        this.peptidegraph = bipartiteGraph;
    }
}

