/*
 * Decompiled with CFR 0.152.
 */
package nmi.assayoptimization;

import java.util.ArrayList;
import nmi.assayoptimization.RandomSelector;
import nmi.assayoptimization.SandwichProteinCovering;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class SandwichFluorescence {
    static int minlengthanalyte = 15;
    static int minlengthpossibledetection = 10;
    static int capturescore = 1;
    static int coverscore = 2;
    static String captureabfile;
    static String markabfile;
    static String subsetfile;
    static String outputfile;
    static int rn_iter;
    static int rn_size;
    static boolean rn_enabled;

    public static void main(String[] stringArray) {
        SandwichProteinCovering sandwichProteinCovering = new SandwichProteinCovering();
        Options options = SandwichFluorescence.createCLO();
        SandwichFluorescence.parseCLO(options, stringArray);
        sandwichProteinCovering.buildGraphs(minlengthanalyte, minlengthpossibledetection, capturescore, coverscore, captureabfile, markabfile);
        sandwichProteinCovering.disableDuplicates();
        sandwichProteinCovering.disableShortEdges(minlengthpossibledetection);
        ArrayList<String> arrayList = new ArrayList();
        if (subsetfile != null) {
            arrayList = SandwichProteinCovering.readList(subsetfile);
            sandwichProteinCovering.deactivateAllButTheseProteins(arrayList);
        }
        ArrayList<Object> arrayList2 = new ArrayList();
        long l = System.currentTimeMillis();
        arrayList2 = sandwichProteinCovering.optimize();
        System.out.println("time " + (System.currentTimeMillis() - l));
        if (rn_enabled) {
            sandwichProteinCovering.reset();
            sandwichProteinCovering.disableDuplicates();
            sandwichProteinCovering.disableShortEdges(minlengthpossibledetection);
            int n = arrayList2.size();
            for (int i = 0; i < rn_iter; ++i) {
                arrayList2 = sandwichProteinCovering.toLabelList(sandwichProteinCovering.localGRASP(arrayList2, new RandomSelector(rn_size)));
                System.out.println(n + " reduced to " + arrayList2.size());
            }
        }
        sandwichProteinCovering.reset();
        sandwichProteinCovering.disableDuplicates();
        sandwichProteinCovering.disableShortEdges(minlengthpossibledetection);
        System.out.println("Checking solution");
        if (sandwichProteinCovering.checkSolution(arrayList2)) {
            System.out.println("Solution is valid!!");
        } else {
            System.out.println("WARNING: Solution is INVALID!!");
        }
        SandwichProteinCovering.writeList(arrayList2, outputfile);
    }

    private static Options createCLO() {
        Options options = new Options();
        OptionBuilder.withDescription((String)"Specify the capture file");
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withArgName((String)"<Capture_File>");
        OptionBuilder.withLongOpt((String)"capturefile");
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withDescription((String)"Specify the marker file");
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withArgName((String)"<Marker_File>");
        OptionBuilder.withLongOpt((String)"markerfile");
        options.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withDescription((String)"Specify the subset file");
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"<Subset_File>");
        OptionBuilder.withLongOpt((String)"subsetfile");
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withDescription((String)"Specify the minimum analyte lenght");
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withArgName((String)"<Minimum_analyte_length as Integer value>");
        OptionBuilder.withLongOpt((String)"analytelength");
        options.addOption(OptionBuilder.create((String)"a"));
        OptionBuilder.withDescription((String)"Specify the minimum length for possible detection");
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withArgName((String)"<Minimum_capture_length as Integer value>");
        OptionBuilder.withLongOpt((String)"detectionlength");
        options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withDescription((String)"Specify the capture score weight");
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withArgName((String)"<Capture_Score_Weight as Integer value>");
        OptionBuilder.withLongOpt((String)"capturescore");
        options.addOption(OptionBuilder.create((String)"v"));
        OptionBuilder.withDescription((String)"Specify the cover score weight");
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withArgName((String)"<Cover_Score_Weightt as Integer value>");
        OptionBuilder.withLongOpt((String)"coverscore");
        options.addOption(OptionBuilder.create((String)"w"));
        OptionBuilder.withDescription((String)"Specify the output filename");
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withLongOpt((String)"outputfile");
        OptionBuilder.withArgName((String)"<Output file>");
        options.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.withDescription((String)"Specify the filename of the log file");
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withLongOpt((String)"log");
        OptionBuilder.withArgName((String)"<Log file>");
        options.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withDescription((String)"Enable random neighbourhood search");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"<Neighbourhood_size as Integer>,<Neighbourhoodsearch_Iterations as Integer>");
        OptionBuilder.withLongOpt((String)"rnhsearch");
        options.addOption(OptionBuilder.create((String)"rn"));
        return options;
    }

    private static void parseCLO(Options options, String[] stringArray) {
        CommandLine commandLine = null;
        GnuParser gnuParser = new GnuParser();
        HelpFormatter helpFormatter = new HelpFormatter();
        try {
            commandLine = gnuParser.parse(options, stringArray);
        }
        catch (Exception exception) {
            helpFormatter.printHelp("java -jar -Xmx1024m svs.jar", options);
            exception.getMessage();
            System.exit(-1);
        }
        if (commandLine.hasOption("c")) {
            captureabfile = commandLine.getOptionValue("c");
            System.out.println("Using " + captureabfile + " as capture file");
        }
        if (commandLine.hasOption("m")) {
            markabfile = commandLine.getOptionValue("m");
            System.out.println("Using " + markabfile + " as marker file");
        }
        if (commandLine.hasOption("s")) {
            subsetfile = commandLine.getOptionValue("s");
            System.out.println("Using " + subsetfile + " as subset file");
        }
        if (commandLine.hasOption("o")) {
            outputfile = commandLine.getOptionValue("o");
            System.out.println("Using " + outputfile + " as output file");
        }
        if (commandLine.hasOption("a")) {
            minlengthanalyte = Integer.parseInt(commandLine.getOptionValue("a"));
            System.out.println("Using " + minlengthanalyte + " as minimum analyte length");
        }
        if (commandLine.hasOption("p")) {
            minlengthpossibledetection = Integer.parseInt(commandLine.getOptionValue("p"));
            System.out.println("Using " + minlengthpossibledetection + " as minimum length for possible detection");
        }
        if (commandLine.hasOption("v")) {
            capturescore = Integer.parseInt(commandLine.getOptionValue("v"));
            System.out.println("Using " + capturescore + " as capture score weight");
        }
        if (commandLine.hasOption("w")) {
            coverscore = Integer.parseInt(commandLine.getOptionValue("w"));
            System.out.println("Using " + coverscore + " as  cover score weight");
        }
        if (commandLine.hasOption("rn")) {
            rn_enabled = true;
            rn_size = Integer.parseInt(commandLine.getOptionValues("rn")[0]);
            rn_iter = Integer.parseInt(commandLine.getOptionValues("rn")[1]);
            System.out.println("Enabled neighbourhood search with " + rn_size + " as subset-size length for " + rn_iter + " iterations");
        }
    }

    static {
        outputfile = "sandwichoutput.txt";
        rn_enabled = false;
    }
}

