/*
 * Decompiled with CFR 0.152.
 */
package nmi.assayoptimization;

import java.util.Random;

public class MCDistributionEstimator
implements Runnable {
    int[] bins;
    int poolsize;
    int numbins;
    int runs;
    int[] result;
    int histsize = 400;
    int[][][] rescache;

    public MCDistributionEstimator(int n, int n2, int n3) {
        this.bins = new int[n];
        this.numbins = n;
        this.poolsize = n2;
        this.runs = n3;
    }

    public int numberofcombinationsstart(int n, int n2) {
        this.rescache = new int[n + 1][n + 1][n2 + 1];
        return this.numberofcombinations(n, n, n2);
    }

    public int numberofcombinations(int n, int n2, int n3) {
        if (n == n3) {
            return 1;
        }
        if (n < n3) {
            return 0;
        }
        int n4 = 0;
        for (int i = n2; i > 0 && n3 * i >= n; --i) {
            if (this.rescache[n - i][i][n3 - 1] != 0) {
                n4 += this.rescache[n - i][i][n3 - 1];
                continue;
            }
            n4 += this.numberofcombinations(n - i, Math.min(i, n - i), n3 - 1);
        }
        this.rescache[n][n2][n3] = n4;
        return n4;
    }

    public int numberofcombinationsalt(int n, int n2) {
        if (n == n2) {
            return 1;
        }
        if (n < n2) {
            return 0;
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        n3 = this.rescache[n - 1][0][n2 - 1] != 0 ? (n3 += this.rescache[n - 1][0][n2 - 1]) : (n3 += this.numberofcombinationsalt(n - 1, n2 - 1));
        n3 = this.rescache[n - n2][0][n2] != 0 ? (n3 += this.rescache[n - n2][0][n2]) : (n3 += this.numberofcombinationsalt(n - n2, n2));
        this.rescache[n][0][n2] = n3;
        return n3;
    }

    public int[] calc() {
        int[] nArray = new int[this.histsize];
        Random random = new Random();
        for (int i = 0; i < this.runs; ++i) {
            int n;
            this.bins = new int[this.numbins];
            for (n = 0; n < this.poolsize; ++n) {
                int n2 = random.nextInt(this.numbins);
                this.bins[n2] = this.bins[n2] + 1;
            }
            for (n = 0; n < this.bins.length; ++n) {
                int n3 = this.bins[n];
                nArray[n3] = nArray[n3] + 1;
            }
        }
        return nArray;
    }

    @Override
    public void run() {
        this.result = this.calc();
    }

    public void runDistributed(int n) {
        int n2;
        int n3 = this.runs / n;
        Thread[] threadArray = new Thread[n];
        MCDistributionEstimator[] mCDistributionEstimatorArray = new MCDistributionEstimator[n];
        for (n2 = 0; n2 < n; ++n2) {
            mCDistributionEstimatorArray[n2] = new MCDistributionEstimator(this.numbins, this.poolsize, n3);
            threadArray[n2] = new Thread(mCDistributionEstimatorArray[n2]);
            threadArray[n2].start();
        }
        for (n2 = 0; n2 < n; ++n2) {
            try {
                threadArray[n2].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        int[] nArray = new int[this.histsize];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                int n4 = i;
                nArray[n4] = nArray[n4] + mCDistributionEstimatorArray[j].result[i];
            }
        }
        this.result = nArray;
    }

    public static void main(String[] stringArray) {
        MCDistributionEstimator mCDistributionEstimator = new MCDistributionEstimator(320000, 1000000, 1000);
        int n = 7;
        for (int i = 1; i <= n; ++i) {
            System.out.println(i + "\t" + mCDistributionEstimator.numberofcombinationsstart(n, i) + " " + mCDistributionEstimator.numberofcombinationsalt(n, i));
        }
    }
}

