/*
 * Decompiled with CFR 0.152.
 */
package nmi.assayoptimization;

import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import nmi.assayoptimization.AntibodyCovering;
import scpsolver.graph.BipartiteGraph;
import scpsolver.graph.Edge;
import scpsolver.graph.Node;

public class CombinationFileStat {
    public static void main(String[] stringArray) {
        AntibodyCovering antibodyCovering = new AntibodyCovering();
        BipartiteGraph bipartiteGraph = AntibodyCovering.readCombinationFile(stringArray[0]);
        if (stringArray.length > 1) {
            ArrayList<Node> arrayList = antibodyCovering.readSolutionFile(stringArray[1], bipartiteGraph);
            ArrayList<Node> arrayList2 = bipartiteGraph.getLeftNodeWithActiveCardinality(0, 100000000);
            for (Node object22 : arrayList2) {
                object22.deactivateAllEdges();
            }
            for (Node node : arrayList) {
                node.activateAllEdges();
            }
            ArrayList<Node> arrayList3 = bipartiteGraph.getRightNodeWithActiveCardinality(0, 1);
            ArrayList<Node> arrayList4 = bipartiteGraph.getRightNodeWithActiveCardinality(2, 10000000);
            ArrayList<Node> arrayList5 = new ArrayList<Node>();
            for (Object object : arrayList4) {
                HashSet<Node> hashSet = new HashSet<Node>();
                hashSet.addAll(((Node)object).getActiveAdjacentNodes());
                if (hashSet.size() <= 1) continue;
                arrayList5.add((Node)object);
            }
            int n = 0;
            try {
                Object object;
                new File(stringArray[1] + "REPORT").mkdir();
                object = new FileWriter(new File(stringArray[1] + "REPORT/index.html"));
                ((Writer)object).write("<html>");
                ((Writer)object).write("<head>");
                ((Writer)object).write("<title></title>");
                ((Writer)object).write("</head>");
                ((Writer)object).write("<body>");
                ((Writer)object).write("<h3>Coverage report</h3>");
                ((Writer)object).write("Combination file: " + stringArray[0] + "<br>");
                ((Writer)object).write("Solution file: " + stringArray[1] + "<br><br>");
                ((Writer)object).write("Number of singlecovered proteins: " + arrayList3.size() + "<br>");
                ((Writer)object).write("Number of multicovered proteins (peptides): " + arrayList4.size() + "<br><br>");
                ((Writer)object).write("Number of multicovered proteins (epitopes): " + arrayList5.size() + "<br><br>");
                ((Writer)object).write("Multicoverage percentage: " + (double)arrayList5.size() / (double)bipartiteGraph.getNumberOfRightNodes() + "<br><br>");
                for (Node node : arrayList) {
                    n += node.getActiveCardinality();
                }
                ((Writer)object).write(n + " covered peptides with " + arrayList.size() + " epitopes in " + bipartiteGraph.getRightNodeWithActiveCardinality(1, 100000000).size() + " proteins. " + "<br><br>");
                Collections.sort(arrayList);
                Collections.reverse(arrayList);
                int n2 = 0;
                ((Writer)object).write("<table>\n");
                ((Writer)object).write("<tr><td>Epitope number</td><td>Epitope</td><td align='left'>covered proteins</td></tr>\n");
                for (Node node : arrayList) {
                    ++n2;
                    String string = node.toString();
                    String string2 = string.replace("|", "X");
                    n += node.getActiveCardinality();
                    ArrayList<Edge> arrayList6 = node.getEdgeList();
                    HashSet<Node> hashSet = new HashSet<Node>();
                    hashSet.addAll(node.getActiveAdjacentNodes());
                    String string3 = "";
                    for (Node node2 : hashSet) {
                        string3 = string3 + "<a href ='http://www.uniprot.org/uniprot/" + node2 + "'>" + node2 + "</a>&nbsp;";
                    }
                    ((Writer)object).write("<tr><td>" + n2 + "</td><td><a href='" + string2 + ".html'>" + node + "</a></td><td>" + string3 + "</td></tr>\n");
                    FileWriter fileWriter = new FileWriter(new File(stringArray[1] + "REPORT/" + string2 + ".html"));
                    fileWriter.write("<html>");
                    fileWriter.write("<head>");
                    fileWriter.write("<title></title>");
                    fileWriter.write("</head>");
                    fileWriter.write("<body>");
                    fileWriter.write("<h3>" + node + "</h3>\n");
                    fileWriter.write("<table>");
                    fileWriter.write("<tr><td>sequence</td><td>protein</td><td>also covered by</td>\n");
                    n += node.getActiveCardinality();
                    for (Edge edge : arrayList6) {
                        HashSet<Node> hashSet2 = new HashSet<Node>();
                        hashSet2.addAll(edge.getNode2().getActiveAdjacentNodes());
                        String string4 = "";
                        for (Node node3 : hashSet2) {
                            if (node3.getLabel().equals(node.getLabel())) continue;
                            string4 = string4 + "&nbsp; <a href='" + node3.toString().replace("|", "X") + ".html#" + node3.toString() + edge.getNode2().toString() + "'>" + node3 + "</a>";
                        }
                        fileWriter.write("<tr><td  id='" + node.toString() + edge.getNode2().toString() + "'><pre>" + edge.getLabel() + "</pre></td><td><a href='http://www.uniprot.org/uniprot/" + edge.getNode2().toString() + "'>" + edge.getNode2().toString() + "</a></td><td>" + string4 + "</td></tr>\n");
                    }
                    fileWriter.write("</table>");
                    fileWriter.write("</body>");
                    fileWriter.flush();
                    fileWriter.close();
                }
                ((OutputStreamWriter)object).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

