/*
 * Decompiled with CFR 0.152.
 */
package nmi.assayoptimization;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import scpsolver.graph.ActiveCardinalityComparator;
import scpsolver.graph.BipartiteGraph;
import scpsolver.graph.EnhancedCoverageComparator;
import scpsolver.graph.Graph;
import scpsolver.graph.Node;
import scpsolver.lpsolver.LinearProgramSolver;
import scpsolver.lpsolver.SolverFactory;
import scpsolver.problems.LinearProgram;

public class AntibodyCovering {
    public static void printNodeList(ArrayList<Node> arrayList) {
        for (Node node : arrayList) {
            System.out.print(node + " ");
        }
        System.out.println();
    }

    public static void writeNodeList(ArrayList<Node> arrayList, String string) {
        try {
            FileWriter fileWriter = new FileWriter(new File(string));
            for (Node node : arrayList) {
                fileWriter.write(node + "\n");
            }
            fileWriter.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static BipartiteGraph readCombinationFile(String string) {
        Object object;
        File file = new File(string);
        BufferedReader bufferedReader = null;
        BipartiteGraph bipartiteGraph = new BipartiteGraph();
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (Exception exception) {
            System.out.print("Cannot read file " + string);
        }
        if (bufferedReader == null) {
            System.exit(-1);
        }
        String string2 = "";
        try {
            string2 = bufferedReader.readLine();
        }
        catch (Exception exception) {
            System.out.print("Cannot first line in file " + string);
        }
        while (string2 != null) {
            object = string2.split("\t");
            String string3 = object[1];
            String string4 = "";
            int n = Integer.parseInt(object[2].substring(1, 2));
            if (object[2].charAt(0) == 'N') {
                if (object[0].length() > n) {
                    string4 = "|" + ((String)object[0]).substring(0, n);
                }
            } else if (object[0].length() > n) {
                string4 = object[0].substring(((String)object[0]).length() - n) + "|";
            }
            if (object[0].length() > n) {
                bipartiteGraph.addEdgeSecure(string4, string3).setLabel((String)object[0]);
            }
            try {
                string2 = bufferedReader.readLine();
            }
            catch (Exception exception) {
                System.out.print("Cannot first line in file " + string);
            }
        }
        System.out.println("Problem analysis");
        System.out.println("\ttotal proteins: " + bipartiteGraph.getNumberOfRightNodes());
        System.out.println("\ttotal antibodies: " + bipartiteGraph.getNumberOfLeftNodes());
        object = bipartiteGraph.getLeftNodeWithCardinality(0, 1);
        System.out.println("\trobinson antibodies: " + ((ArrayList)object).size());
        System.out.println("\trobinson proteins: " + bipartiteGraph.getRightNodeWithCardinality(0, 1).size());
        return bipartiteGraph;
    }

    public static int[] checksolution(BipartiteGraph bipartiteGraph, ArrayList<Node> arrayList, String[] stringArray) {
        int[] nArray = new int[3];
        if (bipartiteGraph.isValidCovering(arrayList)) {
            System.out.println("Solution is valid!");
            String string = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + stringArray[i] + "_";
            }
            AntibodyCovering.writeNodeList(arrayList, string + ".ablist");
            bipartiteGraph.sortCovering(arrayList, string + ".ablist.sort");
            System.out.println("Set size " + arrayList.size() + " of " + bipartiteGraph.getNumberOfRightNodes());
            ArrayList<Node> arrayList2 = bipartiteGraph.getLeftNodeWithActiveCardinality(0, 100000000);
            for (Node object2 : arrayList2) {
                object2.deactivateAllEdges();
            }
            for (Node node : arrayList) {
                node.activateAllEdges();
            }
            ArrayList<Node> arrayList3 = bipartiteGraph.getRightNodeWithActiveCardinality(0, 1);
            ArrayList<Node> arrayList4 = bipartiteGraph.getRightNodeWithActiveCardinality(2, 10000000);
            nArray[0] = arrayList3.size();
            nArray[1] = arrayList4.size();
            nArray[2] = arrayList.size();
            System.out.println("single covered: " + arrayList3.size());
            System.out.println("multi covered: " + arrayList4.size());
        } else {
            System.out.println("Solution is invalid!");
            String string = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + stringArray[i] + "_";
            }
            AntibodyCovering.writeNodeList(arrayList, string + "PARTIALCOVERING.ablist");
            bipartiteGraph.sortCovering(arrayList, string + "PARTIALCOVERING.ablist.sort");
            HashSet<Node> hashSet = new HashSet<Node>();
            for (Node node : arrayList) {
                hashSet.addAll(node.getAdjacentNodes());
            }
            System.out.println(hashSet.size() + " covered");
            AntibodyCovering.writeNodeList(new ArrayList<Node>(hashSet), string + "PARTIALCOVERING.proteinlist");
        }
        return nArray;
    }

    public ArrayList<Node> readSolutionFile(String string, Graph graph) {
        System.out.println("Checking solution.. " + string);
        File file = new File(string);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (file.exists()) {
            BufferedReader bufferedReader = null;
            String string2 = "";
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string3 = bufferedReader.readLine();
                while (string3 != null) {
                    string2 = string2 + " " + string3;
                    string3 = bufferedReader.readLine();
                }
                System.out.println(string2);
                arrayList = graph.getNodeSet(string2.toString());
            }
            catch (Exception exception) {
                System.out.print(exception);
            }
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        File file = new File(stringArray[0]);
        BufferedReader bufferedReader = null;
        BipartiteGraph bipartiteGraph = new BipartiteGraph();
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (Exception exception) {
            System.out.print("Cannot read file " + stringArray[0]);
        }
        if (bufferedReader == null) {
            System.exit(-1);
        }
        String string = "";
        try {
            string = bufferedReader.readLine();
        }
        catch (Exception exception) {
            System.out.print("Cannot first line in file " + stringArray[0]);
        }
        while (string != null) {
            object4 = string.split("\t");
            object3 = object4[1];
            object2 = "";
            int n = Integer.parseInt(object4[2].substring(1, 2));
            if (object4[2].charAt(0) == 'N') {
                if (object4[0].length() > n) {
                    object2 = "|" + ((String)object4[0]).substring(0, n);
                }
            } else if (object4[0].length() > n) {
                object2 = object4[0].substring(((String)object4[0]).length() - n) + "|";
            }
            bipartiteGraph.addEdgeSecure((String)object2, (String)object3);
            try {
                string = bufferedReader.readLine();
            }
            catch (Exception exception) {
                System.out.print("Cannot first line in file " + stringArray[0]);
            }
        }
        System.out.println("Problem analysis");
        System.out.println("\ttotal proteins: " + bipartiteGraph.getNumberOfRightNodes());
        System.out.println("\ttotal antibodies: " + bipartiteGraph.getNumberOfLeftNodes());
        object4 = bipartiteGraph.getLeftNodeWithCardinality(0, 1);
        System.out.println("\trobinson antibodies: " + ((ArrayList)object4).size());
        System.out.println("\trobinson proteins: " + bipartiteGraph.getRightNodeWithCardinality(0, 1).size());
        object3 = new ArrayList();
        for (Node node : bipartiteGraph.getNodesright().values()) {
            if (!((AbstractCollection)object4).containsAll(node.getActiveAdjacentNodes())) continue;
            ((ArrayList)object3).add(node);
        }
        if (!((ArrayList)object3).isEmpty()) {
            System.out.print("\tproteins covered only by robinson antibodies: ");
            AntibodyCovering.printNodeList((ArrayList<Node>)object3);
        }
        System.out.println("Cleaning robinson antibodies..");
        object2 = ((ArrayList)object4).iterator();
        while (object2.hasNext()) {
            Node node = (Node)object2.next();
            boolean bl = false;
            Iterator iterator = ((ArrayList)object3).iterator();
            while (iterator.hasNext()) {
                object = (Node)iterator.next();
                if (!node.getActiveAdjacentNodes().contains(object)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            bipartiteGraph.removeLeftNode(node);
        }
        System.out.println("done..");
        object2 = "IP";
        if (stringArray.length > 1) {
            object2 = stringArray[1];
        }
        ArrayList<Object> arrayList = new ArrayList();
        long l = System.currentTimeMillis();
        if (((String)object2).equals("GREEDY")) {
            System.out.println("Greedy heuristic:");
            arrayList = bipartiteGraph.solveSetCoveringProblemGreedyActive(new ActiveCardinalityComparator());
        } else if (((String)object2).equals("GREEDYMAX")) {
            System.out.println("Greedy heuristic:");
            arrayList = bipartiteGraph.solveSetCoveringProblemGreedyActive(new ActiveCardinalityComparator(), Integer.parseInt(stringArray[2]));
        } else if (((String)object2).equals("GREEDYEHCOVERAGE")) {
            System.out.println("Greedy heuristic:");
            int n = 100;
            if (stringArray.length > 2) {
                n = Integer.parseInt(stringArray[2]);
            }
            int n2 = 1;
            if (stringArray.length > 3) {
                n2 = Integer.parseInt(stringArray[3]);
            }
            System.out.println("scov " + n + " smcov " + n2);
            arrayList = bipartiteGraph.solveSetCoveringProblemGreedyActive(new EnhancedCoverageComparator(n, n2));
        } else if (((String)object2).equals("IPLP")) {
            object = bipartiteGraph.getSetCoverLinearProgram(1);
            try {
                FileWriter fileWriter = new FileWriter(new File(stringArray[0] + "_IP.lp"));
                fileWriter.write(((LinearProgram)object).convertToCPLEX().toString());
                fileWriter.close();
            }
            catch (Exception exception) {}
        } else if (((String)object2).equals("MCLP")) {
            object = bipartiteGraph.getSetCoverLinearProgramMulticover();
            try {
                FileWriter fileWriter = new FileWriter(new File(stringArray[0] + "_IPMC.lp"));
                fileWriter.write(((LinearProgram)object).convertToCPLEX().toString());
                fileWriter.close();
            }
            catch (Exception exception) {}
        } else if (((String)object2).equals("MMCLP")) {
            int n = bipartiteGraph.getNumberOfRightNodes();
            if (stringArray.length > 2) {
                n = Integer.parseInt(stringArray[2]);
            }
            LinearProgram linearProgram = bipartiteGraph.getDualCoverLinearProgram(n);
            try {
                FileWriter fileWriter = new FileWriter(new File(stringArray[0] + "_IPMMC_" + n + ".lp"));
                fileWriter.write(linearProgram.convertToCPLEX().toString());
                fileWriter.close();
            }
            catch (Exception exception) {}
        } else if (((String)object2).equals("IPHEURCPLEXSOLVE")) {
            int n = 1;
            if (stringArray.length > 2) {
                n = Integer.parseInt(stringArray[2]);
            }
            LinearProgramSolver linearProgramSolver = SolverFactory.getSolver("CPLEX");
            System.out.println("Solving relaxed ILP..");
            arrayList = bipartiteGraph.solveCoveringProblemLPApproximation(linearProgramSolver);
        } else if (((String)object2).equals("IPMCSOLVE")) {
            object = SolverFactory.getSolver("CPLEX");
            System.out.println("Solving relaxed ILP..");
            arrayList = bipartiteGraph.solveCoveringProblemLPMulticover((LinearProgramSolver)object);
        } else if (((String)object2).equals("IPSOLVE")) {
            int n = 1;
            String string2 = "default";
            if (stringArray.length > 2) {
                string2 = stringArray[2];
            }
            if (stringArray.length > 3) {
                n = Integer.parseInt(stringArray[3]);
            }
            LinearProgramSolver linearProgramSolver = string2.equals("default") ? SolverFactory.newDefault() : SolverFactory.getSolver(string2);
            arrayList = bipartiteGraph.solveCoveringProblemLP(linearProgramSolver, n);
        } else if (((String)object2).equals("IPSOLVEMAX")) {
            int n = 1;
            String string3 = "default";
            if (stringArray.length > 2) {
                string3 = stringArray[2];
            }
            if (stringArray.length > 3) {
                n = Integer.parseInt(stringArray[3]);
            }
            LinearProgramSolver linearProgramSolver = string3.equals("default") ? SolverFactory.newDefault() : SolverFactory.getSolver(string3);
            if (stringArray.length > 4) {
                int n3 = Integer.parseInt(stringArray[4]);
                System.out.println("time limit:" + n3);
                linearProgramSolver.setTimeconstraint(n3);
            }
            arrayList = bipartiteGraph.solveDenseCoveringProblemLP(linearProgramSolver, n);
        } else if (((String)object2).equals("IPSOLVEDUAL")) {
            int n = bipartiteGraph.getNumberOfRightNodes();
            String string4 = "default";
            if (stringArray.length > 2) {
                string4 = stringArray[2];
            }
            if (stringArray.length > 3) {
                n = Integer.parseInt(stringArray[3]);
            }
            LinearProgramSolver linearProgramSolver = string4.equals("default") ? SolverFactory.newDefault() : SolverFactory.getSolver(string4);
            if (stringArray.length > 4) {
                int n4 = Integer.parseInt(stringArray[4]);
                System.out.println("time limit:" + n4);
                linearProgramSolver.setTimeconstraint(n4);
            }
            arrayList = bipartiteGraph.solveDualCoveringProblemLP(linearProgramSolver, n);
        } else {
            System.out.println("Checking solution.. " + stringArray[1]);
            object = new File(stringArray[1]);
            if (((File)object).exists()) {
                BufferedReader bufferedReader2 = null;
                String string5 = "";
                try {
                    bufferedReader2 = new BufferedReader(new FileReader((File)object));
                    string = bufferedReader2.readLine();
                    while (string != null) {
                        string5 = string5 + " " + string;
                        string = bufferedReader2.readLine();
                    }
                    arrayList = bipartiteGraph.getNodeSet(string5.toString());
                }
                catch (Exception exception) {
                    System.out.print(exception);
                }
            }
        }
        long l2 = System.currentTimeMillis();
        System.out.println(arrayList.size());
        System.out.println("elapsed time: " + (l2 - l) / 1000L + " seconds");
        AntibodyCovering.checksolution(bipartiteGraph, arrayList, stringArray);
    }
}

